/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SIZE;
    public static final int USAGE;
    public static final int SHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;

    VkBufferCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkBufferCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBufferCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkBufferCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkBufferCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkBufferCreateInfo.nflags(this.address());
    }

    public long size() {
        return VkBufferCreateInfo.nsize(this.address());
    }

    public int usage() {
        return VkBufferCreateInfo.nusage(this.address());
    }

    public int sharingMode() {
        return VkBufferCreateInfo.nsharingMode(this.address());
    }

    public int queueFamilyIndexCount() {
        return VkBufferCreateInfo.nqueueFamilyIndexCount(this.address());
    }

    public IntBuffer pQueueFamilyIndices() {
        return VkBufferCreateInfo.npQueueFamilyIndices(this.address());
    }

    public VkBufferCreateInfo sType(int value) {
        VkBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo pNext(long value) {
        VkBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo flags(int value) {
        VkBufferCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo size(long value) {
        VkBufferCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo usage(int value) {
        VkBufferCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo sharingMode(int value) {
        VkBufferCreateInfo.nsharingMode(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo pQueueFamilyIndices(IntBuffer value) {
        VkBufferCreateInfo.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo set(int sType, long pNext, int flags, long size, int usage, int sharingMode, IntBuffer pQueueFamilyIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.size(size);
        this.usage(usage);
        this.sharingMode(sharingMode);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        return this;
    }

    public VkBufferCreateInfo set(VkBufferCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferCreateInfo malloc() {
        return VkBufferCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkBufferCreateInfo calloc() {
        return VkBufferCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkBufferCreateInfo create() {
        return new VkBufferCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBufferCreateInfo create(long address) {
        return address == 0L ? null : new VkBufferCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkBufferCreateInfo mallocStack() {
        return VkBufferCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferCreateInfo callocStack() {
        return VkBufferCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferCreateInfo mallocStack(MemoryStack stack) {
        return VkBufferCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferCreateInfo callocStack(MemoryStack stack) {
        return VkBufferCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int nusage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USAGE);
    }

    public static int nsharingMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES), VkBufferCreateInfo.nqueueFamilyIndexCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    public static void nusage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USAGE, value);
    }

    public static void nsharingMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEFAMILYINDICES, MemoryUtil.memAddressSafe(value));
        VkBufferCreateInfo.nqueueFamilyIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBufferCreateInfo.nqueueFamilyIndexCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkBufferCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkBufferCreateInfo.__struct(VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(POINTER_SIZE), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(8), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SIZE = layout.offsetof(3);
        USAGE = layout.offsetof(4);
        SHARINGMODE = layout.offsetof(5);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(6);
        PQUEUEFAMILYINDICES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBufferCreateInfo newInstance(long address) {
            return new VkBufferCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkBufferCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkBufferCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkBufferCreateInfo.nflags(this.address());
        }

        public long size() {
            return VkBufferCreateInfo.nsize(this.address());
        }

        public int usage() {
            return VkBufferCreateInfo.nusage(this.address());
        }

        public int sharingMode() {
            return VkBufferCreateInfo.nsharingMode(this.address());
        }

        public int queueFamilyIndexCount() {
            return VkBufferCreateInfo.nqueueFamilyIndexCount(this.address());
        }

        public IntBuffer pQueueFamilyIndices() {
            return VkBufferCreateInfo.npQueueFamilyIndices(this.address());
        }

        public Buffer sType(int value) {
            VkBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkBufferCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            VkBufferCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer usage(int value) {
            VkBufferCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer sharingMode(int value) {
            VkBufferCreateInfo.nsharingMode(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(IntBuffer value) {
            VkBufferCreateInfo.npQueueFamilyIndices(this.address(), value);
            return this;
        }
    }
}

