/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferMemoryBarrier
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;

    VkBufferMemoryBarrier(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkBufferMemoryBarrier(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBufferMemoryBarrier.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkBufferMemoryBarrier.nsType(this.address());
    }

    public long pNext() {
        return VkBufferMemoryBarrier.npNext(this.address());
    }

    public int srcAccessMask() {
        return VkBufferMemoryBarrier.nsrcAccessMask(this.address());
    }

    public int dstAccessMask() {
        return VkBufferMemoryBarrier.ndstAccessMask(this.address());
    }

    public int srcQueueFamilyIndex() {
        return VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address());
    }

    public int dstQueueFamilyIndex() {
        return VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address());
    }

    public long buffer() {
        return VkBufferMemoryBarrier.nbuffer(this.address());
    }

    public long offset() {
        return VkBufferMemoryBarrier.noffset(this.address());
    }

    public long size() {
        return VkBufferMemoryBarrier.nsize(this.address());
    }

    public VkBufferMemoryBarrier sType(int value) {
        VkBufferMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier pNext(long value) {
        VkBufferMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier srcAccessMask(int value) {
        VkBufferMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier dstAccessMask(int value) {
        VkBufferMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier srcQueueFamilyIndex(int value) {
        VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier dstQueueFamilyIndex(int value) {
        VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier buffer(long value) {
        VkBufferMemoryBarrier.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier offset(long value) {
        VkBufferMemoryBarrier.noffset(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier size(long value) {
        VkBufferMemoryBarrier.nsize(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long buffer, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkBufferMemoryBarrier set(VkBufferMemoryBarrier src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferMemoryBarrier malloc() {
        return VkBufferMemoryBarrier.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkBufferMemoryBarrier calloc() {
        return VkBufferMemoryBarrier.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkBufferMemoryBarrier create() {
        return new VkBufferMemoryBarrier(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBufferMemoryBarrier create(long address) {
        return address == 0L ? null : new VkBufferMemoryBarrier(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferMemoryBarrier.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferMemoryBarrier.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkBufferMemoryBarrier mallocStack() {
        return VkBufferMemoryBarrier.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferMemoryBarrier callocStack() {
        return VkBufferMemoryBarrier.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferMemoryBarrier mallocStack(MemoryStack stack) {
        return VkBufferMemoryBarrier.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferMemoryBarrier callocStack(MemoryStack stack) {
        return VkBufferMemoryBarrier.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferMemoryBarrier.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferMemoryBarrier.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryBarrier.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryBarrier.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsrcAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTACCESSMASK);
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCQUEUEFAMILYINDEX);
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTQUEUEFAMILYINDEX);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTACCESSMASK, value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCQUEUEFAMILYINDEX, value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTQUEUEFAMILYINDEX, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkBufferMemoryBarrier.__struct(VkBufferMemoryBarrier.__member(4), VkBufferMemoryBarrier.__member(POINTER_SIZE), VkBufferMemoryBarrier.__member(4), VkBufferMemoryBarrier.__member(4), VkBufferMemoryBarrier.__member(4), VkBufferMemoryBarrier.__member(4), VkBufferMemoryBarrier.__member(8), VkBufferMemoryBarrier.__member(8), VkBufferMemoryBarrier.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
        SRCQUEUEFAMILYINDEX = layout.offsetof(4);
        DSTQUEUEFAMILYINDEX = layout.offsetof(5);
        BUFFER = layout.offsetof(6);
        OFFSET = layout.offsetof(7);
        SIZE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBufferMemoryBarrier, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBufferMemoryBarrier newInstance(long address) {
            return new VkBufferMemoryBarrier(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkBufferMemoryBarrier.nsType(this.address());
        }

        public long pNext() {
            return VkBufferMemoryBarrier.npNext(this.address());
        }

        public int srcAccessMask() {
            return VkBufferMemoryBarrier.nsrcAccessMask(this.address());
        }

        public int dstAccessMask() {
            return VkBufferMemoryBarrier.ndstAccessMask(this.address());
        }

        public int srcQueueFamilyIndex() {
            return VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address());
        }

        public int dstQueueFamilyIndex() {
            return VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address());
        }

        public long buffer() {
            return VkBufferMemoryBarrier.nbuffer(this.address());
        }

        public long offset() {
            return VkBufferMemoryBarrier.noffset(this.address());
        }

        public long size() {
            return VkBufferMemoryBarrier.nsize(this.address());
        }

        public Buffer sType(int value) {
            VkBufferMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkBufferMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(int value) {
            VkBufferMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(int value) {
            VkBufferMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(int value) {
            VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(int value) {
            VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer buffer(long value) {
            VkBufferMemoryBarrier.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(long value) {
            VkBufferMemoryBarrier.noffset(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            VkBufferMemoryBarrier.nsize(this.address(), value);
            return this;
        }
    }
}

