/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;

public class VkClearAttachment
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int COLORATTACHMENT;
    public static final int CLEARVALUE;

    VkClearAttachment(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkClearAttachment(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkClearAttachment.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int aspectMask() {
        return VkClearAttachment.naspectMask(this.address());
    }

    public int colorAttachment() {
        return VkClearAttachment.ncolorAttachment(this.address());
    }

    public VkClearValue clearValue() {
        return VkClearAttachment.nclearValue(this.address());
    }

    public VkClearAttachment aspectMask(int value) {
        VkClearAttachment.naspectMask(this.address(), value);
        return this;
    }

    public VkClearAttachment colorAttachment(int value) {
        VkClearAttachment.ncolorAttachment(this.address(), value);
        return this;
    }

    public VkClearAttachment clearValue(VkClearValue value) {
        VkClearAttachment.nclearValue(this.address(), value);
        return this;
    }

    public VkClearAttachment set(int aspectMask, int colorAttachment, VkClearValue clearValue) {
        this.aspectMask(aspectMask);
        this.colorAttachment(colorAttachment);
        this.clearValue(clearValue);
        return this;
    }

    public VkClearAttachment set(VkClearAttachment src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearAttachment malloc() {
        return VkClearAttachment.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkClearAttachment calloc() {
        return VkClearAttachment.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkClearAttachment create() {
        return new VkClearAttachment(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkClearAttachment create(long address) {
        return address == 0L ? null : new VkClearAttachment(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkClearAttachment.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearAttachment.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkClearAttachment mallocStack() {
        return VkClearAttachment.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearAttachment callocStack() {
        return VkClearAttachment.callocStack(MemoryStack.stackGet());
    }

    public static VkClearAttachment mallocStack(MemoryStack stack) {
        return VkClearAttachment.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearAttachment callocStack(MemoryStack stack) {
        return VkClearAttachment.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearAttachment.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearAttachment.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearAttachment.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearAttachment.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static int ncolorAttachment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORATTACHMENT);
    }

    public static VkClearValue nclearValue(long struct) {
        return VkClearValue.create(struct + (long)CLEARVALUE);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTMASK, value);
    }

    public static void ncolorAttachment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORATTACHMENT, value);
    }

    public static void nclearValue(long struct, VkClearValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CLEARVALUE, VkClearValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearAttachment.__struct(VkClearAttachment.__member(4), VkClearAttachment.__member(4), VkClearAttachment.__member(VkClearValue.SIZEOF, VkClearValue.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        COLORATTACHMENT = layout.offsetof(1);
        CLEARVALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearAttachment, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkClearAttachment newInstance(long address) {
            return new VkClearAttachment(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int aspectMask() {
            return VkClearAttachment.naspectMask(this.address());
        }

        public int colorAttachment() {
            return VkClearAttachment.ncolorAttachment(this.address());
        }

        public VkClearValue clearValue() {
            return VkClearAttachment.nclearValue(this.address());
        }

        public Buffer aspectMask(int value) {
            VkClearAttachment.naspectMask(this.address(), value);
            return this;
        }

        public Buffer colorAttachment(int value) {
            VkClearAttachment.ncolorAttachment(this.address(), value);
            return this;
        }

        public Buffer clearValue(VkClearValue value) {
            VkClearAttachment.nclearValue(this.address(), value);
            return this;
        }
    }
}

