/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearColorValue;
import org.lwjgl.vulkan.VkClearDepthStencilValue;

public class VkClearValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int DEPTHSTENCIL;

    VkClearValue(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkClearValue(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkClearValue.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkClearColorValue color() {
        return VkClearValue.ncolor(this.address());
    }

    public VkClearDepthStencilValue depthStencil() {
        return VkClearValue.ndepthStencil(this.address());
    }

    public VkClearValue color(VkClearColorValue value) {
        VkClearValue.ncolor(this.address(), value);
        return this;
    }

    public VkClearValue depthStencil(VkClearDepthStencilValue value) {
        VkClearValue.ndepthStencil(this.address(), value);
        return this;
    }

    public VkClearValue set(VkClearValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearValue malloc() {
        return VkClearValue.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkClearValue calloc() {
        return VkClearValue.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkClearValue create() {
        return new VkClearValue(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkClearValue create(long address) {
        return address == 0L ? null : new VkClearValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkClearValue.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearValue.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkClearValue mallocStack() {
        return VkClearValue.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearValue callocStack() {
        return VkClearValue.callocStack(MemoryStack.stackGet());
    }

    public static VkClearValue mallocStack(MemoryStack stack) {
        return VkClearValue.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearValue callocStack(MemoryStack stack) {
        return VkClearValue.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearValue.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearValue.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkClearColorValue ncolor(long struct) {
        return VkClearColorValue.create(struct + (long)COLOR);
    }

    public static VkClearDepthStencilValue ndepthStencil(long struct) {
        return VkClearDepthStencilValue.create(struct + (long)DEPTHSTENCIL);
    }

    public static void ncolor(long struct, VkClearColorValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, VkClearColorValue.SIZEOF);
    }

    public static void ndepthStencil(long struct, VkClearDepthStencilValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTHSTENCIL, VkClearDepthStencilValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearValue.__union(VkClearValue.__member(VkClearColorValue.SIZEOF, VkClearColorValue.ALIGNOF), VkClearValue.__member(VkClearDepthStencilValue.SIZEOF, VkClearDepthStencilValue.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        DEPTHSTENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearValue, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkClearValue newInstance(long address) {
            return new VkClearValue(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkClearColorValue color() {
            return VkClearValue.ncolor(this.address());
        }

        public VkClearDepthStencilValue depthStencil() {
            return VkClearValue.ndepthStencil(this.address());
        }

        public Buffer color(VkClearColorValue value) {
            VkClearValue.ncolor(this.address(), value);
            return this;
        }

        public Buffer depthStencil(VkClearDepthStencilValue value) {
            VkClearValue.ndepthStencil(this.address(), value);
            return this;
        }
    }
}

