/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkIndirectCommandsTokenNVX;

public class VkCmdProcessCommandsInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTABLE;
    public static final int INDIRECTCOMMANDSLAYOUT;
    public static final int INDIRECTCOMMANDSTOKENCOUNT;
    public static final int PINDIRECTCOMMANDSTOKENS;
    public static final int MAXSEQUENCESCOUNT;
    public static final int TARGETCOMMANDBUFFER;
    public static final int SEQUENCESCOUNTBUFFER;
    public static final int SEQUENCESCOUNTOFFSET;
    public static final int SEQUENCESINDEXBUFFER;
    public static final int SEQUENCESINDEXOFFSET;

    VkCmdProcessCommandsInfoNVX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkCmdProcessCommandsInfoNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCmdProcessCommandsInfoNVX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkCmdProcessCommandsInfoNVX.nsType(this.address());
    }

    public long pNext() {
        return VkCmdProcessCommandsInfoNVX.npNext(this.address());
    }

    public long objectTable() {
        return VkCmdProcessCommandsInfoNVX.nobjectTable(this.address());
    }

    public long indirectCommandsLayout() {
        return VkCmdProcessCommandsInfoNVX.nindirectCommandsLayout(this.address());
    }

    public int indirectCommandsTokenCount() {
        return VkCmdProcessCommandsInfoNVX.nindirectCommandsTokenCount(this.address());
    }

    public VkIndirectCommandsTokenNVX.Buffer pIndirectCommandsTokens() {
        return VkCmdProcessCommandsInfoNVX.npIndirectCommandsTokens(this.address());
    }

    public int maxSequencesCount() {
        return VkCmdProcessCommandsInfoNVX.nmaxSequencesCount(this.address());
    }

    public long targetCommandBuffer() {
        return VkCmdProcessCommandsInfoNVX.ntargetCommandBuffer(this.address());
    }

    public long sequencesCountBuffer() {
        return VkCmdProcessCommandsInfoNVX.nsequencesCountBuffer(this.address());
    }

    public long sequencesCountOffset() {
        return VkCmdProcessCommandsInfoNVX.nsequencesCountOffset(this.address());
    }

    public long sequencesIndexBuffer() {
        return VkCmdProcessCommandsInfoNVX.nsequencesIndexBuffer(this.address());
    }

    public long sequencesIndexOffset() {
        return VkCmdProcessCommandsInfoNVX.nsequencesIndexOffset(this.address());
    }

    public VkCmdProcessCommandsInfoNVX sType(int value) {
        VkCmdProcessCommandsInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX pNext(long value) {
        VkCmdProcessCommandsInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX objectTable(long value) {
        VkCmdProcessCommandsInfoNVX.nobjectTable(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX indirectCommandsLayout(long value) {
        VkCmdProcessCommandsInfoNVX.nindirectCommandsLayout(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX pIndirectCommandsTokens(VkIndirectCommandsTokenNVX.Buffer value) {
        VkCmdProcessCommandsInfoNVX.npIndirectCommandsTokens(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX maxSequencesCount(int value) {
        VkCmdProcessCommandsInfoNVX.nmaxSequencesCount(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX targetCommandBuffer(VkCommandBuffer value) {
        VkCmdProcessCommandsInfoNVX.ntargetCommandBuffer(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX sequencesCountBuffer(long value) {
        VkCmdProcessCommandsInfoNVX.nsequencesCountBuffer(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX sequencesCountOffset(long value) {
        VkCmdProcessCommandsInfoNVX.nsequencesCountOffset(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX sequencesIndexBuffer(long value) {
        VkCmdProcessCommandsInfoNVX.nsequencesIndexBuffer(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX sequencesIndexOffset(long value) {
        VkCmdProcessCommandsInfoNVX.nsequencesIndexOffset(this.address(), value);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX set(int sType, long pNext, long objectTable, long indirectCommandsLayout, VkIndirectCommandsTokenNVX.Buffer pIndirectCommandsTokens, int maxSequencesCount, VkCommandBuffer targetCommandBuffer, long sequencesCountBuffer, long sequencesCountOffset, long sequencesIndexBuffer, long sequencesIndexOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectTable(objectTable);
        this.indirectCommandsLayout(indirectCommandsLayout);
        this.pIndirectCommandsTokens(pIndirectCommandsTokens);
        this.maxSequencesCount(maxSequencesCount);
        this.targetCommandBuffer(targetCommandBuffer);
        this.sequencesCountBuffer(sequencesCountBuffer);
        this.sequencesCountOffset(sequencesCountOffset);
        this.sequencesIndexBuffer(sequencesIndexBuffer);
        this.sequencesIndexOffset(sequencesIndexOffset);
        return this;
    }

    public VkCmdProcessCommandsInfoNVX set(VkCmdProcessCommandsInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCmdProcessCommandsInfoNVX malloc() {
        return VkCmdProcessCommandsInfoNVX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkCmdProcessCommandsInfoNVX calloc() {
        return VkCmdProcessCommandsInfoNVX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkCmdProcessCommandsInfoNVX create() {
        return new VkCmdProcessCommandsInfoNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCmdProcessCommandsInfoNVX create(long address) {
        return address == 0L ? null : new VkCmdProcessCommandsInfoNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkCmdProcessCommandsInfoNVX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCmdProcessCommandsInfoNVX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkCmdProcessCommandsInfoNVX mallocStack() {
        return VkCmdProcessCommandsInfoNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkCmdProcessCommandsInfoNVX callocStack() {
        return VkCmdProcessCommandsInfoNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkCmdProcessCommandsInfoNVX mallocStack(MemoryStack stack) {
        return VkCmdProcessCommandsInfoNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCmdProcessCommandsInfoNVX callocStack(MemoryStack stack) {
        return VkCmdProcessCommandsInfoNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCmdProcessCommandsInfoNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCmdProcessCommandsInfoNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCmdProcessCommandsInfoNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCmdProcessCommandsInfoNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nobjectTable(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OBJECTTABLE);
    }

    public static long nindirectCommandsLayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)INDIRECTCOMMANDSLAYOUT);
    }

    public static int nindirectCommandsTokenCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDIRECTCOMMANDSTOKENCOUNT);
    }

    public static VkIndirectCommandsTokenNVX.Buffer npIndirectCommandsTokens(long struct) {
        return VkIndirectCommandsTokenNVX.create(MemoryUtil.memGetAddress(struct + (long)PINDIRECTCOMMANDSTOKENS), VkCmdProcessCommandsInfoNVX.nindirectCommandsTokenCount(struct));
    }

    public static int nmaxSequencesCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSEQUENCESCOUNT);
    }

    public static long ntargetCommandBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TARGETCOMMANDBUFFER);
    }

    public static long nsequencesCountBuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SEQUENCESCOUNTBUFFER);
    }

    public static long nsequencesCountOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SEQUENCESCOUNTOFFSET);
    }

    public static long nsequencesIndexBuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SEQUENCESINDEXBUFFER);
    }

    public static long nsequencesIndexOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SEQUENCESINDEXOFFSET);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nobjectTable(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OBJECTTABLE, value);
    }

    public static void nindirectCommandsLayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)INDIRECTCOMMANDSLAYOUT, value);
    }

    public static void nindirectCommandsTokenCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDIRECTCOMMANDSTOKENCOUNT, value);
    }

    public static void npIndirectCommandsTokens(long struct, VkIndirectCommandsTokenNVX.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINDIRECTCOMMANDSTOKENS, value.address());
        VkCmdProcessCommandsInfoNVX.nindirectCommandsTokenCount(struct, value.remaining());
    }

    public static void nmaxSequencesCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXSEQUENCESCOUNT, value);
    }

    public static void ntargetCommandBuffer(long struct, VkCommandBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)TARGETCOMMANDBUFFER, VkCmdProcessCommandsInfoNVX.addressSafe(value));
    }

    public static void nsequencesCountBuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SEQUENCESCOUNTBUFFER, value);
    }

    public static void nsequencesCountOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SEQUENCESCOUNTOFFSET, value);
    }

    public static void nsequencesIndexBuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SEQUENCESINDEXBUFFER, value);
    }

    public static void nsequencesIndexOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SEQUENCESINDEXOFFSET, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PINDIRECTCOMMANDSTOKENS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkCmdProcessCommandsInfoNVX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkCmdProcessCommandsInfoNVX.__struct(VkCmdProcessCommandsInfoNVX.__member(4), VkCmdProcessCommandsInfoNVX.__member(POINTER_SIZE), VkCmdProcessCommandsInfoNVX.__member(8), VkCmdProcessCommandsInfoNVX.__member(8), VkCmdProcessCommandsInfoNVX.__member(4), VkCmdProcessCommandsInfoNVX.__member(POINTER_SIZE), VkCmdProcessCommandsInfoNVX.__member(4), VkCmdProcessCommandsInfoNVX.__member(POINTER_SIZE), VkCmdProcessCommandsInfoNVX.__member(8), VkCmdProcessCommandsInfoNVX.__member(8), VkCmdProcessCommandsInfoNVX.__member(8), VkCmdProcessCommandsInfoNVX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTABLE = layout.offsetof(2);
        INDIRECTCOMMANDSLAYOUT = layout.offsetof(3);
        INDIRECTCOMMANDSTOKENCOUNT = layout.offsetof(4);
        PINDIRECTCOMMANDSTOKENS = layout.offsetof(5);
        MAXSEQUENCESCOUNT = layout.offsetof(6);
        TARGETCOMMANDBUFFER = layout.offsetof(7);
        SEQUENCESCOUNTBUFFER = layout.offsetof(8);
        SEQUENCESCOUNTOFFSET = layout.offsetof(9);
        SEQUENCESINDEXBUFFER = layout.offsetof(10);
        SEQUENCESINDEXOFFSET = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkCmdProcessCommandsInfoNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCmdProcessCommandsInfoNVX newInstance(long address) {
            return new VkCmdProcessCommandsInfoNVX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkCmdProcessCommandsInfoNVX.nsType(this.address());
        }

        public long pNext() {
            return VkCmdProcessCommandsInfoNVX.npNext(this.address());
        }

        public long objectTable() {
            return VkCmdProcessCommandsInfoNVX.nobjectTable(this.address());
        }

        public long indirectCommandsLayout() {
            return VkCmdProcessCommandsInfoNVX.nindirectCommandsLayout(this.address());
        }

        public int indirectCommandsTokenCount() {
            return VkCmdProcessCommandsInfoNVX.nindirectCommandsTokenCount(this.address());
        }

        public VkIndirectCommandsTokenNVX.Buffer pIndirectCommandsTokens() {
            return VkCmdProcessCommandsInfoNVX.npIndirectCommandsTokens(this.address());
        }

        public int maxSequencesCount() {
            return VkCmdProcessCommandsInfoNVX.nmaxSequencesCount(this.address());
        }

        public long targetCommandBuffer() {
            return VkCmdProcessCommandsInfoNVX.ntargetCommandBuffer(this.address());
        }

        public long sequencesCountBuffer() {
            return VkCmdProcessCommandsInfoNVX.nsequencesCountBuffer(this.address());
        }

        public long sequencesCountOffset() {
            return VkCmdProcessCommandsInfoNVX.nsequencesCountOffset(this.address());
        }

        public long sequencesIndexBuffer() {
            return VkCmdProcessCommandsInfoNVX.nsequencesIndexBuffer(this.address());
        }

        public long sequencesIndexOffset() {
            return VkCmdProcessCommandsInfoNVX.nsequencesIndexOffset(this.address());
        }

        public Buffer sType(int value) {
            VkCmdProcessCommandsInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkCmdProcessCommandsInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer objectTable(long value) {
            VkCmdProcessCommandsInfoNVX.nobjectTable(this.address(), value);
            return this;
        }

        public Buffer indirectCommandsLayout(long value) {
            VkCmdProcessCommandsInfoNVX.nindirectCommandsLayout(this.address(), value);
            return this;
        }

        public Buffer pIndirectCommandsTokens(VkIndirectCommandsTokenNVX.Buffer value) {
            VkCmdProcessCommandsInfoNVX.npIndirectCommandsTokens(this.address(), value);
            return this;
        }

        public Buffer maxSequencesCount(int value) {
            VkCmdProcessCommandsInfoNVX.nmaxSequencesCount(this.address(), value);
            return this;
        }

        public Buffer targetCommandBuffer(VkCommandBuffer value) {
            VkCmdProcessCommandsInfoNVX.ntargetCommandBuffer(this.address(), value);
            return this;
        }

        public Buffer sequencesCountBuffer(long value) {
            VkCmdProcessCommandsInfoNVX.nsequencesCountBuffer(this.address(), value);
            return this;
        }

        public Buffer sequencesCountOffset(long value) {
            VkCmdProcessCommandsInfoNVX.nsequencesCountOffset(this.address(), value);
            return this;
        }

        public Buffer sequencesIndexBuffer(long value) {
            VkCmdProcessCommandsInfoNVX.nsequencesIndexBuffer(this.address(), value);
            return this;
        }

        public Buffer sequencesIndexOffset(long value) {
            VkCmdProcessCommandsInfoNVX.nsequencesIndexOffset(this.address(), value);
            return this;
        }
    }
}

