/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandBufferAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COMMANDPOOL;
    public static final int LEVEL;
    public static final int COMMANDBUFFERCOUNT;

    VkCommandBufferAllocateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkCommandBufferAllocateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCommandBufferAllocateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkCommandBufferAllocateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkCommandBufferAllocateInfo.npNext(this.address());
    }

    public long commandPool() {
        return VkCommandBufferAllocateInfo.ncommandPool(this.address());
    }

    public int level() {
        return VkCommandBufferAllocateInfo.nlevel(this.address());
    }

    public int commandBufferCount() {
        return VkCommandBufferAllocateInfo.ncommandBufferCount(this.address());
    }

    public VkCommandBufferAllocateInfo sType(int value) {
        VkCommandBufferAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo pNext(long value) {
        VkCommandBufferAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo commandPool(long value) {
        VkCommandBufferAllocateInfo.ncommandPool(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo level(int value) {
        VkCommandBufferAllocateInfo.nlevel(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo commandBufferCount(int value) {
        VkCommandBufferAllocateInfo.ncommandBufferCount(this.address(), value);
        return this;
    }

    public VkCommandBufferAllocateInfo set(int sType, long pNext, long commandPool, int level, int commandBufferCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.commandPool(commandPool);
        this.level(level);
        this.commandBufferCount(commandBufferCount);
        return this;
    }

    public VkCommandBufferAllocateInfo set(VkCommandBufferAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCommandBufferAllocateInfo malloc() {
        return VkCommandBufferAllocateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkCommandBufferAllocateInfo calloc() {
        return VkCommandBufferAllocateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkCommandBufferAllocateInfo create() {
        return new VkCommandBufferAllocateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCommandBufferAllocateInfo create(long address) {
        return address == 0L ? null : new VkCommandBufferAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkCommandBufferAllocateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCommandBufferAllocateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkCommandBufferAllocateInfo mallocStack() {
        return VkCommandBufferAllocateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferAllocateInfo callocStack() {
        return VkCommandBufferAllocateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferAllocateInfo mallocStack(MemoryStack stack) {
        return VkCommandBufferAllocateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferAllocateInfo callocStack(MemoryStack stack) {
        return VkCommandBufferAllocateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferAllocateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCommandBufferAllocateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferAllocateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferAllocateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ncommandPool(long struct) {
        return MemoryUtil.memGetLong(struct + (long)COMMANDPOOL);
    }

    public static int nlevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEVEL);
    }

    public static int ncommandBufferCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMMANDBUFFERCOUNT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncommandPool(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)COMMANDPOOL, value);
    }

    public static void nlevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LEVEL, value);
    }

    public static void ncommandBufferCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMMANDBUFFERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkCommandBufferAllocateInfo.__struct(VkCommandBufferAllocateInfo.__member(4), VkCommandBufferAllocateInfo.__member(POINTER_SIZE), VkCommandBufferAllocateInfo.__member(8), VkCommandBufferAllocateInfo.__member(4), VkCommandBufferAllocateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COMMANDPOOL = layout.offsetof(2);
        LEVEL = layout.offsetof(3);
        COMMANDBUFFERCOUNT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferAllocateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCommandBufferAllocateInfo newInstance(long address) {
            return new VkCommandBufferAllocateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkCommandBufferAllocateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkCommandBufferAllocateInfo.npNext(this.address());
        }

        public long commandPool() {
            return VkCommandBufferAllocateInfo.ncommandPool(this.address());
        }

        public int level() {
            return VkCommandBufferAllocateInfo.nlevel(this.address());
        }

        public int commandBufferCount() {
            return VkCommandBufferAllocateInfo.ncommandBufferCount(this.address());
        }

        public Buffer sType(int value) {
            VkCommandBufferAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkCommandBufferAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer commandPool(long value) {
            VkCommandBufferAllocateInfo.ncommandPool(this.address(), value);
            return this;
        }

        public Buffer level(int value) {
            VkCommandBufferAllocateInfo.nlevel(this.address(), value);
            return this;
        }

        public Buffer commandBufferCount(int value) {
            VkCommandBufferAllocateInfo.ncommandBufferCount(this.address(), value);
            return this;
        }
    }
}

