/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandBufferInheritanceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RENDERPASS;
    public static final int SUBPASS;
    public static final int FRAMEBUFFER;
    public static final int OCCLUSIONQUERYENABLE;
    public static final int QUERYFLAGS;
    public static final int PIPELINESTATISTICS;

    VkCommandBufferInheritanceInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkCommandBufferInheritanceInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCommandBufferInheritanceInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkCommandBufferInheritanceInfo.nsType(this.address());
    }

    public long pNext() {
        return VkCommandBufferInheritanceInfo.npNext(this.address());
    }

    public long renderPass() {
        return VkCommandBufferInheritanceInfo.nrenderPass(this.address());
    }

    public int subpass() {
        return VkCommandBufferInheritanceInfo.nsubpass(this.address());
    }

    public long framebuffer() {
        return VkCommandBufferInheritanceInfo.nframebuffer(this.address());
    }

    public boolean occlusionQueryEnable() {
        return VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address()) != 0;
    }

    public int queryFlags() {
        return VkCommandBufferInheritanceInfo.nqueryFlags(this.address());
    }

    public int pipelineStatistics() {
        return VkCommandBufferInheritanceInfo.npipelineStatistics(this.address());
    }

    public VkCommandBufferInheritanceInfo sType(int value) {
        VkCommandBufferInheritanceInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo pNext(long value) {
        VkCommandBufferInheritanceInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo renderPass(long value) {
        VkCommandBufferInheritanceInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo subpass(int value) {
        VkCommandBufferInheritanceInfo.nsubpass(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo framebuffer(long value) {
        VkCommandBufferInheritanceInfo.nframebuffer(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo occlusionQueryEnable(boolean value) {
        VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkCommandBufferInheritanceInfo queryFlags(int value) {
        VkCommandBufferInheritanceInfo.nqueryFlags(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo pipelineStatistics(int value) {
        VkCommandBufferInheritanceInfo.npipelineStatistics(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo set(int sType, long pNext, long renderPass, int subpass, long framebuffer, boolean occlusionQueryEnable, int queryFlags, int pipelineStatistics) {
        this.sType(sType);
        this.pNext(pNext);
        this.renderPass(renderPass);
        this.subpass(subpass);
        this.framebuffer(framebuffer);
        this.occlusionQueryEnable(occlusionQueryEnable);
        this.queryFlags(queryFlags);
        this.pipelineStatistics(pipelineStatistics);
        return this;
    }

    public VkCommandBufferInheritanceInfo set(VkCommandBufferInheritanceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCommandBufferInheritanceInfo malloc() {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo calloc() {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo create() {
        return new VkCommandBufferInheritanceInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo create(long address) {
        return address == 0L ? null : new VkCommandBufferInheritanceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCommandBufferInheritanceInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkCommandBufferInheritanceInfo mallocStack() {
        return VkCommandBufferInheritanceInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferInheritanceInfo callocStack() {
        return VkCommandBufferInheritanceInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferInheritanceInfo mallocStack(MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo callocStack(MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferInheritanceInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCommandBufferInheritanceInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCommandBufferInheritanceInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RENDERPASS);
    }

    public static int nsubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASS);
    }

    public static long nframebuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FRAMEBUFFER);
    }

    public static int nocclusionQueryEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OCCLUSIONQUERYENABLE);
    }

    public static int nqueryFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUERYFLAGS);
    }

    public static int npipelineStatistics(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINESTATISTICS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RENDERPASS, value);
    }

    public static void nsubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASS, value);
    }

    public static void nframebuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FRAMEBUFFER, value);
    }

    public static void nocclusionQueryEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OCCLUSIONQUERYENABLE, value);
    }

    public static void nqueryFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUERYFLAGS, value);
    }

    public static void npipelineStatistics(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINESTATISTICS, value);
    }

    static {
        Struct.Layout layout = VkCommandBufferInheritanceInfo.__struct(VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(POINTER_SIZE), VkCommandBufferInheritanceInfo.__member(8), VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(8), VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(4), VkCommandBufferInheritanceInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RENDERPASS = layout.offsetof(2);
        SUBPASS = layout.offsetof(3);
        FRAMEBUFFER = layout.offsetof(4);
        OCCLUSIONQUERYENABLE = layout.offsetof(5);
        QUERYFLAGS = layout.offsetof(6);
        PIPELINESTATISTICS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferInheritanceInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCommandBufferInheritanceInfo newInstance(long address) {
            return new VkCommandBufferInheritanceInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkCommandBufferInheritanceInfo.nsType(this.address());
        }

        public long pNext() {
            return VkCommandBufferInheritanceInfo.npNext(this.address());
        }

        public long renderPass() {
            return VkCommandBufferInheritanceInfo.nrenderPass(this.address());
        }

        public int subpass() {
            return VkCommandBufferInheritanceInfo.nsubpass(this.address());
        }

        public long framebuffer() {
            return VkCommandBufferInheritanceInfo.nframebuffer(this.address());
        }

        public boolean occlusionQueryEnable() {
            return VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address()) != 0;
        }

        public int queryFlags() {
            return VkCommandBufferInheritanceInfo.nqueryFlags(this.address());
        }

        public int pipelineStatistics() {
            return VkCommandBufferInheritanceInfo.npipelineStatistics(this.address());
        }

        public Buffer sType(int value) {
            VkCommandBufferInheritanceInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkCommandBufferInheritanceInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer renderPass(long value) {
            VkCommandBufferInheritanceInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer subpass(int value) {
            VkCommandBufferInheritanceInfo.nsubpass(this.address(), value);
            return this;
        }

        public Buffer framebuffer(long value) {
            VkCommandBufferInheritanceInfo.nframebuffer(this.address(), value);
            return this;
        }

        public Buffer occlusionQueryEnable(boolean value) {
            VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer queryFlags(int value) {
            VkCommandBufferInheritanceInfo.nqueryFlags(this.address(), value);
            return this;
        }

        public Buffer pipelineStatistics(int value) {
            VkCommandBufferInheritanceInfo.npipelineStatistics(this.address(), value);
            return this;
        }
    }
}

