/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;

public class VkComputePipelineCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGE;
    public static final int LAYOUT;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    VkComputePipelineCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkComputePipelineCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkComputePipelineCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkComputePipelineCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkComputePipelineCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkComputePipelineCreateInfo.nflags(this.address());
    }

    public VkPipelineShaderStageCreateInfo stage() {
        return VkComputePipelineCreateInfo.nstage(this.address());
    }

    public long layout() {
        return VkComputePipelineCreateInfo.nlayout(this.address());
    }

    public long basePipelineHandle() {
        return VkComputePipelineCreateInfo.nbasePipelineHandle(this.address());
    }

    public int basePipelineIndex() {
        return VkComputePipelineCreateInfo.nbasePipelineIndex(this.address());
    }

    public VkComputePipelineCreateInfo sType(int value) {
        VkComputePipelineCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo pNext(long value) {
        VkComputePipelineCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo flags(int value) {
        VkComputePipelineCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo stage(VkPipelineShaderStageCreateInfo value) {
        VkComputePipelineCreateInfo.nstage(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo layout(long value) {
        VkComputePipelineCreateInfo.nlayout(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo basePipelineHandle(long value) {
        VkComputePipelineCreateInfo.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo basePipelineIndex(int value) {
        VkComputePipelineCreateInfo.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo set(int sType, long pNext, int flags, VkPipelineShaderStageCreateInfo stage, long layout, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stage(stage);
        this.layout(layout);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkComputePipelineCreateInfo set(VkComputePipelineCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkComputePipelineCreateInfo malloc() {
        return VkComputePipelineCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkComputePipelineCreateInfo calloc() {
        return VkComputePipelineCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkComputePipelineCreateInfo create() {
        return new VkComputePipelineCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkComputePipelineCreateInfo create(long address) {
        return address == 0L ? null : new VkComputePipelineCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkComputePipelineCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkComputePipelineCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkComputePipelineCreateInfo mallocStack() {
        return VkComputePipelineCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkComputePipelineCreateInfo callocStack() {
        return VkComputePipelineCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkComputePipelineCreateInfo mallocStack(MemoryStack stack) {
        return VkComputePipelineCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkComputePipelineCreateInfo callocStack(MemoryStack stack) {
        return VkComputePipelineCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkComputePipelineCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkComputePipelineCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkComputePipelineCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkComputePipelineCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static VkPipelineShaderStageCreateInfo nstage(long struct) {
        return VkPipelineShaderStageCreateInfo.create(struct + (long)STAGE);
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYOUT);
    }

    public static long nbasePipelineHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BASEPIPELINEHANDLE);
    }

    public static int nbasePipelineIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEPIPELINEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nstage(long struct, VkPipelineShaderStageCreateInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)STAGE, VkPipelineShaderStageCreateInfo.SIZEOF);
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYOUT, value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BASEPIPELINEHANDLE, value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEPIPELINEINDEX, value);
    }

    public static void validate(long struct) {
        VkPipelineShaderStageCreateInfo.validate(struct + (long)STAGE);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkComputePipelineCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkComputePipelineCreateInfo.__struct(VkComputePipelineCreateInfo.__member(4), VkComputePipelineCreateInfo.__member(POINTER_SIZE), VkComputePipelineCreateInfo.__member(4), VkComputePipelineCreateInfo.__member(VkPipelineShaderStageCreateInfo.SIZEOF, VkPipelineShaderStageCreateInfo.ALIGNOF), VkComputePipelineCreateInfo.__member(8), VkComputePipelineCreateInfo.__member(8), VkComputePipelineCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGE = layout.offsetof(3);
        LAYOUT = layout.offsetof(4);
        BASEPIPELINEHANDLE = layout.offsetof(5);
        BASEPIPELINEINDEX = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkComputePipelineCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkComputePipelineCreateInfo newInstance(long address) {
            return new VkComputePipelineCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkComputePipelineCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkComputePipelineCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkComputePipelineCreateInfo.nflags(this.address());
        }

        public VkPipelineShaderStageCreateInfo stage() {
            return VkComputePipelineCreateInfo.nstage(this.address());
        }

        public long layout() {
            return VkComputePipelineCreateInfo.nlayout(this.address());
        }

        public long basePipelineHandle() {
            return VkComputePipelineCreateInfo.nbasePipelineHandle(this.address());
        }

        public int basePipelineIndex() {
            return VkComputePipelineCreateInfo.nbasePipelineIndex(this.address());
        }

        public Buffer sType(int value) {
            VkComputePipelineCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkComputePipelineCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkComputePipelineCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer stage(VkPipelineShaderStageCreateInfo value) {
            VkComputePipelineCreateInfo.nstage(this.address(), value);
            return this;
        }

        public Buffer layout(long value) {
            VkComputePipelineCreateInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(long value) {
            VkComputePipelineCreateInfo.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(int value) {
            VkComputePipelineCreateInfo.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

