/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerObjectNameInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECT;
    public static final int POBJECTNAME;

    VkDebugMarkerObjectNameInfoEXT(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDebugMarkerObjectNameInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugMarkerObjectNameInfoEXT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDebugMarkerObjectNameInfoEXT.nsType(this.address());
    }

    public long pNext() {
        return VkDebugMarkerObjectNameInfoEXT.npNext(this.address());
    }

    public int objectType() {
        return VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address());
    }

    public long object() {
        return VkDebugMarkerObjectNameInfoEXT.nobject(this.address());
    }

    public ByteBuffer pObjectName() {
        return VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address());
    }

    public String pObjectNameString() {
        return VkDebugMarkerObjectNameInfoEXT.npObjectNameString(this.address());
    }

    public VkDebugMarkerObjectNameInfoEXT sType(int value) {
        VkDebugMarkerObjectNameInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT pNext(long value) {
        VkDebugMarkerObjectNameInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT objectType(int value) {
        VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT object(long value) {
        VkDebugMarkerObjectNameInfoEXT.nobject(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT pObjectName(ByteBuffer value) {
        VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT set(int sType, long pNext, int objectType, long object, ByteBuffer pObjectName) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.object(object);
        this.pObjectName(pObjectName);
        return this;
    }

    public VkDebugMarkerObjectNameInfoEXT set(VkDebugMarkerObjectNameInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugMarkerObjectNameInfoEXT malloc() {
        return VkDebugMarkerObjectNameInfoEXT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT calloc() {
        return VkDebugMarkerObjectNameInfoEXT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT create() {
        return new VkDebugMarkerObjectNameInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT create(long address) {
        return address == 0L ? null : new VkDebugMarkerObjectNameInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDebugMarkerObjectNameInfoEXT mallocStack() {
        return VkDebugMarkerObjectNameInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerObjectNameInfoEXT callocStack() {
        return VkDebugMarkerObjectNameInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugMarkerObjectNameInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerObjectNameInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerObjectNameInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectNameInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nobjectType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTTYPE);
    }

    public static long nobject(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OBJECT);
    }

    public static ByteBuffer npObjectName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)POBJECTNAME));
    }

    public static String npObjectNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)POBJECTNAME));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nobjectType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTTYPE, value);
    }

    public static void nobject(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OBJECT, value);
    }

    public static void npObjectName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)POBJECTNAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POBJECTNAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugMarkerObjectNameInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugMarkerObjectNameInfoEXT.__struct(VkDebugMarkerObjectNameInfoEXT.__member(4), VkDebugMarkerObjectNameInfoEXT.__member(POINTER_SIZE), VkDebugMarkerObjectNameInfoEXT.__member(4), VkDebugMarkerObjectNameInfoEXT.__member(8), VkDebugMarkerObjectNameInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECT = layout.offsetof(3);
        POBJECTNAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerObjectNameInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugMarkerObjectNameInfoEXT newInstance(long address) {
            return new VkDebugMarkerObjectNameInfoEXT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDebugMarkerObjectNameInfoEXT.nsType(this.address());
        }

        public long pNext() {
            return VkDebugMarkerObjectNameInfoEXT.npNext(this.address());
        }

        public int objectType() {
            return VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address());
        }

        public long object() {
            return VkDebugMarkerObjectNameInfoEXT.nobject(this.address());
        }

        public ByteBuffer pObjectName() {
            return VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address());
        }

        public String pObjectNameString() {
            return VkDebugMarkerObjectNameInfoEXT.npObjectNameString(this.address());
        }

        public Buffer sType(int value) {
            VkDebugMarkerObjectNameInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDebugMarkerObjectNameInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(int value) {
            VkDebugMarkerObjectNameInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer object(long value) {
            VkDebugMarkerObjectNameInfoEXT.nobject(this.address(), value);
            return this;
        }

        public Buffer pObjectName(ByteBuffer value) {
            VkDebugMarkerObjectNameInfoEXT.npObjectName(this.address(), value);
            return this;
        }
    }
}

