/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorSetAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DESCRIPTORPOOL;
    public static final int DESCRIPTORSETCOUNT;
    public static final int PSETLAYOUTS;

    VkDescriptorSetAllocateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorSetAllocateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorSetAllocateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDescriptorSetAllocateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkDescriptorSetAllocateInfo.npNext(this.address());
    }

    public long descriptorPool() {
        return VkDescriptorSetAllocateInfo.ndescriptorPool(this.address());
    }

    public int descriptorSetCount() {
        return VkDescriptorSetAllocateInfo.ndescriptorSetCount(this.address());
    }

    public LongBuffer pSetLayouts() {
        return VkDescriptorSetAllocateInfo.npSetLayouts(this.address());
    }

    public VkDescriptorSetAllocateInfo sType(int value) {
        VkDescriptorSetAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo pNext(long value) {
        VkDescriptorSetAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo descriptorPool(long value) {
        VkDescriptorSetAllocateInfo.ndescriptorPool(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo pSetLayouts(LongBuffer value) {
        VkDescriptorSetAllocateInfo.npSetLayouts(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo set(int sType, long pNext, long descriptorPool, LongBuffer pSetLayouts) {
        this.sType(sType);
        this.pNext(pNext);
        this.descriptorPool(descriptorPool);
        this.pSetLayouts(pSetLayouts);
        return this;
    }

    public VkDescriptorSetAllocateInfo set(VkDescriptorSetAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetAllocateInfo malloc() {
        return VkDescriptorSetAllocateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDescriptorSetAllocateInfo calloc() {
        return VkDescriptorSetAllocateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDescriptorSetAllocateInfo create() {
        return new VkDescriptorSetAllocateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorSetAllocateInfo create(long address) {
        return address == 0L ? null : new VkDescriptorSetAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetAllocateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetAllocateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDescriptorSetAllocateInfo mallocStack() {
        return VkDescriptorSetAllocateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetAllocateInfo callocStack() {
        return VkDescriptorSetAllocateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetAllocateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetAllocateInfo callocStack(MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetAllocateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetAllocateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ndescriptorPool(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DESCRIPTORPOOL);
    }

    public static int ndescriptorSetCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORSETCOUNT);
    }

    public static LongBuffer npSetLayouts(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS), VkDescriptorSetAllocateInfo.ndescriptorSetCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndescriptorPool(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DESCRIPTORPOOL, value);
    }

    public static void ndescriptorSetCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORSETCOUNT, value);
    }

    public static void npSetLayouts(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSETLAYOUTS, MemoryUtil.memAddress(value));
        VkDescriptorSetAllocateInfo.ndescriptorSetCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDescriptorSetAllocateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetAllocateInfo.__struct(VkDescriptorSetAllocateInfo.__member(4), VkDescriptorSetAllocateInfo.__member(POINTER_SIZE), VkDescriptorSetAllocateInfo.__member(8), VkDescriptorSetAllocateInfo.__member(4), VkDescriptorSetAllocateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DESCRIPTORPOOL = layout.offsetof(2);
        DESCRIPTORSETCOUNT = layout.offsetof(3);
        PSETLAYOUTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetAllocateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorSetAllocateInfo newInstance(long address) {
            return new VkDescriptorSetAllocateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDescriptorSetAllocateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkDescriptorSetAllocateInfo.npNext(this.address());
        }

        public long descriptorPool() {
            return VkDescriptorSetAllocateInfo.ndescriptorPool(this.address());
        }

        public int descriptorSetCount() {
            return VkDescriptorSetAllocateInfo.ndescriptorSetCount(this.address());
        }

        public LongBuffer pSetLayouts() {
            return VkDescriptorSetAllocateInfo.npSetLayouts(this.address());
        }

        public Buffer sType(int value) {
            VkDescriptorSetAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDescriptorSetAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer descriptorPool(long value) {
            VkDescriptorSetAllocateInfo.ndescriptorPool(this.address(), value);
            return this;
        }

        public Buffer pSetLayouts(LongBuffer value) {
            VkDescriptorSetAllocateInfo.npSetLayouts(this.address(), value);
            return this;
        }
    }
}

