/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorSetLayoutBinding
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BINDING;
    public static final int DESCRIPTORTYPE;
    public static final int DESCRIPTORCOUNT;
    public static final int STAGEFLAGS;
    public static final int PIMMUTABLESAMPLERS;

    VkDescriptorSetLayoutBinding(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorSetLayoutBinding(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorSetLayoutBinding.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int binding() {
        return VkDescriptorSetLayoutBinding.nbinding(this.address());
    }

    public int descriptorType() {
        return VkDescriptorSetLayoutBinding.ndescriptorType(this.address());
    }

    public int descriptorCount() {
        return VkDescriptorSetLayoutBinding.ndescriptorCount(this.address());
    }

    public int stageFlags() {
        return VkDescriptorSetLayoutBinding.nstageFlags(this.address());
    }

    public LongBuffer pImmutableSamplers() {
        return VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address());
    }

    public VkDescriptorSetLayoutBinding binding(int value) {
        VkDescriptorSetLayoutBinding.nbinding(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding descriptorType(int value) {
        VkDescriptorSetLayoutBinding.ndescriptorType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding descriptorCount(int value) {
        VkDescriptorSetLayoutBinding.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding stageFlags(int value) {
        VkDescriptorSetLayoutBinding.nstageFlags(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding pImmutableSamplers(LongBuffer value) {
        VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding set(int binding, int descriptorType, int descriptorCount, int stageFlags, LongBuffer pImmutableSamplers) {
        this.binding(binding);
        this.descriptorType(descriptorType);
        this.descriptorCount(descriptorCount);
        this.stageFlags(stageFlags);
        this.pImmutableSamplers(pImmutableSamplers);
        return this;
    }

    public VkDescriptorSetLayoutBinding set(VkDescriptorSetLayoutBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutBinding malloc() {
        return VkDescriptorSetLayoutBinding.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding calloc() {
        return VkDescriptorSetLayoutBinding.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding create() {
        return new VkDescriptorSetLayoutBinding(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding create(long address) {
        return address == 0L ? null : new VkDescriptorSetLayoutBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutBinding.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutBinding.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDescriptorSetLayoutBinding mallocStack() {
        return VkDescriptorSetLayoutBinding.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutBinding callocStack() {
        return VkDescriptorSetLayoutBinding.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutBinding mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutBinding.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutBinding.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDING);
    }

    public static int ndescriptorType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORTYPE);
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORCOUNT);
    }

    public static int nstageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGEFLAGS);
    }

    public static LongBuffer npImmutableSamplers(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PIMMUTABLESAMPLERS), VkDescriptorSetLayoutBinding.ndescriptorCount(struct));
    }

    public static void nbinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDING, value);
    }

    public static void ndescriptorType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORTYPE, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void nstageFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGEFLAGS, value);
    }

    public static void npImmutableSamplers(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMMUTABLESAMPLERS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkDescriptorSetLayoutBinding.ndescriptorCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutBinding.__struct(VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BINDING = layout.offsetof(0);
        DESCRIPTORTYPE = layout.offsetof(1);
        DESCRIPTORCOUNT = layout.offsetof(2);
        STAGEFLAGS = layout.offsetof(3);
        PIMMUTABLESAMPLERS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutBinding, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorSetLayoutBinding newInstance(long address) {
            return new VkDescriptorSetLayoutBinding(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int binding() {
            return VkDescriptorSetLayoutBinding.nbinding(this.address());
        }

        public int descriptorType() {
            return VkDescriptorSetLayoutBinding.ndescriptorType(this.address());
        }

        public int descriptorCount() {
            return VkDescriptorSetLayoutBinding.ndescriptorCount(this.address());
        }

        public int stageFlags() {
            return VkDescriptorSetLayoutBinding.nstageFlags(this.address());
        }

        public LongBuffer pImmutableSamplers() {
            return VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address());
        }

        public Buffer binding(int value) {
            VkDescriptorSetLayoutBinding.nbinding(this.address(), value);
            return this;
        }

        public Buffer descriptorType(int value) {
            VkDescriptorSetLayoutBinding.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(int value) {
            VkDescriptorSetLayoutBinding.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer stageFlags(int value) {
            VkDescriptorSetLayoutBinding.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer pImmutableSamplers(LongBuffer value) {
            VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address(), value);
            return this;
        }
    }
}

