/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorUpdateTemplateEntryKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;
    public static final int DESCRIPTORTYPE;
    public static final int OFFSET;
    public static final int STRIDE;

    VkDescriptorUpdateTemplateEntryKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorUpdateTemplateEntryKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorUpdateTemplateEntryKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int dstBinding() {
        return VkDescriptorUpdateTemplateEntryKHR.ndstBinding(this.address());
    }

    public int dstArrayElement() {
        return VkDescriptorUpdateTemplateEntryKHR.ndstArrayElement(this.address());
    }

    public int descriptorCount() {
        return VkDescriptorUpdateTemplateEntryKHR.ndescriptorCount(this.address());
    }

    public int descriptorType() {
        return VkDescriptorUpdateTemplateEntryKHR.ndescriptorType(this.address());
    }

    public long offset() {
        return VkDescriptorUpdateTemplateEntryKHR.noffset(this.address());
    }

    public long stride() {
        return VkDescriptorUpdateTemplateEntryKHR.nstride(this.address());
    }

    public VkDescriptorUpdateTemplateEntryKHR dstBinding(int value) {
        VkDescriptorUpdateTemplateEntryKHR.ndstBinding(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR dstArrayElement(int value) {
        VkDescriptorUpdateTemplateEntryKHR.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR descriptorCount(int value) {
        VkDescriptorUpdateTemplateEntryKHR.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR descriptorType(int value) {
        VkDescriptorUpdateTemplateEntryKHR.ndescriptorType(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR offset(long value) {
        VkDescriptorUpdateTemplateEntryKHR.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR stride(long value) {
        VkDescriptorUpdateTemplateEntryKHR.nstride(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR set(int dstBinding, int dstArrayElement, int descriptorCount, int descriptorType, long offset, long stride) {
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        this.descriptorType(descriptorType);
        this.offset(offset);
        this.stride(stride);
        return this;
    }

    public VkDescriptorUpdateTemplateEntryKHR set(VkDescriptorUpdateTemplateEntryKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorUpdateTemplateEntryKHR malloc() {
        return VkDescriptorUpdateTemplateEntryKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntryKHR calloc() {
        return VkDescriptorUpdateTemplateEntryKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntryKHR create() {
        return new VkDescriptorUpdateTemplateEntryKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntryKHR create(long address) {
        return address == 0L ? null : new VkDescriptorUpdateTemplateEntryKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorUpdateTemplateEntryKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorUpdateTemplateEntryKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDescriptorUpdateTemplateEntryKHR mallocStack() {
        return VkDescriptorUpdateTemplateEntryKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorUpdateTemplateEntryKHR callocStack() {
        return VkDescriptorUpdateTemplateEntryKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorUpdateTemplateEntryKHR mallocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntryKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntryKHR callocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntryKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorUpdateTemplateEntryKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorUpdateTemplateEntryKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntryKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntryKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndstBinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTBINDING);
    }

    public static int ndstArrayElement(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTARRAYELEMENT);
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORCOUNT);
    }

    public static int ndescriptorType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORTYPE);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    public static long nstride(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)STRIDE);
    }

    public static void ndstBinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTBINDING, value);
    }

    public static void ndstArrayElement(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTARRAYELEMENT, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void ndescriptorType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORTYPE, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OFFSET, value);
    }

    public static void nstride(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorUpdateTemplateEntryKHR.__struct(VkDescriptorUpdateTemplateEntryKHR.__member(4), VkDescriptorUpdateTemplateEntryKHR.__member(4), VkDescriptorUpdateTemplateEntryKHR.__member(4), VkDescriptorUpdateTemplateEntryKHR.__member(4), VkDescriptorUpdateTemplateEntryKHR.__member(POINTER_SIZE), VkDescriptorUpdateTemplateEntryKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DSTBINDING = layout.offsetof(0);
        DSTARRAYELEMENT = layout.offsetof(1);
        DESCRIPTORCOUNT = layout.offsetof(2);
        DESCRIPTORTYPE = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        STRIDE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorUpdateTemplateEntryKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorUpdateTemplateEntryKHR newInstance(long address) {
            return new VkDescriptorUpdateTemplateEntryKHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int dstBinding() {
            return VkDescriptorUpdateTemplateEntryKHR.ndstBinding(this.address());
        }

        public int dstArrayElement() {
            return VkDescriptorUpdateTemplateEntryKHR.ndstArrayElement(this.address());
        }

        public int descriptorCount() {
            return VkDescriptorUpdateTemplateEntryKHR.ndescriptorCount(this.address());
        }

        public int descriptorType() {
            return VkDescriptorUpdateTemplateEntryKHR.ndescriptorType(this.address());
        }

        public long offset() {
            return VkDescriptorUpdateTemplateEntryKHR.noffset(this.address());
        }

        public long stride() {
            return VkDescriptorUpdateTemplateEntryKHR.nstride(this.address());
        }

        public Buffer dstBinding(int value) {
            VkDescriptorUpdateTemplateEntryKHR.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(int value) {
            VkDescriptorUpdateTemplateEntryKHR.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(int value) {
            VkDescriptorUpdateTemplateEntryKHR.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer descriptorType(int value) {
            VkDescriptorUpdateTemplateEntryKHR.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer offset(long value) {
            VkDescriptorUpdateTemplateEntryKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer stride(long value) {
            VkDescriptorUpdateTemplateEntryKHR.nstride(this.address(), value);
            return this;
        }
    }
}

