/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleDevice;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class VkDevice
extends DispatchableHandleDevice {
    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        super(handle, VkDevice.getDeviceCapabilities(handle, physicalDevice, ci));
    }

    private static VKCapabilitiesDevice getDeviceCapabilities(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        long vkGetDeviceProcAddr;
        VKCapabilitiesInstance capsInstance = physicalDevice.getCapabilities();
        try (MemoryStack stack = MemoryStack.stackPush();){
            vkGetDeviceProcAddr = JNI.callPPP(VK.getGlobalCommands().vkGetInstanceProcAddr, physicalDevice.getInstance().address(), MemoryUtil.memAddress(stack.ASCII("vkGetDeviceProcAddr")));
        }
        return new VKCapabilitiesDevice(functionName -> {
            long address = JNI.callPPP(vkGetDeviceProcAddr, handle, MemoryUtil.memAddress(functionName));
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for VK device function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }, capsInstance, VK.getEnabledExtensionSet(capsInstance.apiVersion, ci.ppEnabledExtensionNames()));
    }
}

