/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceEventInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEEVENT;

    VkDeviceEventInfoEXT(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceEventInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceEventInfoEXT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceEventInfoEXT.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceEventInfoEXT.npNext(this.address());
    }

    public int deviceEvent() {
        return VkDeviceEventInfoEXT.ndeviceEvent(this.address());
    }

    public VkDeviceEventInfoEXT sType(int value) {
        VkDeviceEventInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDeviceEventInfoEXT pNext(long value) {
        VkDeviceEventInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDeviceEventInfoEXT deviceEvent(int value) {
        VkDeviceEventInfoEXT.ndeviceEvent(this.address(), value);
        return this;
    }

    public VkDeviceEventInfoEXT set(int sType, long pNext, int deviceEvent) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceEvent(deviceEvent);
        return this;
    }

    public VkDeviceEventInfoEXT set(VkDeviceEventInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceEventInfoEXT malloc() {
        return VkDeviceEventInfoEXT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceEventInfoEXT calloc() {
        return VkDeviceEventInfoEXT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceEventInfoEXT create() {
        return new VkDeviceEventInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceEventInfoEXT create(long address) {
        return address == 0L ? null : new VkDeviceEventInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceEventInfoEXT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceEventInfoEXT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceEventInfoEXT mallocStack() {
        return VkDeviceEventInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceEventInfoEXT callocStack() {
        return VkDeviceEventInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceEventInfoEXT mallocStack(MemoryStack stack) {
        return VkDeviceEventInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceEventInfoEXT callocStack(MemoryStack stack) {
        return VkDeviceEventInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceEventInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceEventInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceEventInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceEventInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndeviceEvent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEEVENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndeviceEvent(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEEVENT, value);
    }

    static {
        Struct.Layout layout = VkDeviceEventInfoEXT.__struct(VkDeviceEventInfoEXT.__member(4), VkDeviceEventInfoEXT.__member(POINTER_SIZE), VkDeviceEventInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEEVENT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceEventInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceEventInfoEXT newInstance(long address) {
            return new VkDeviceEventInfoEXT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceEventInfoEXT.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceEventInfoEXT.npNext(this.address());
        }

        public int deviceEvent() {
            return VkDeviceEventInfoEXT.ndeviceEvent(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceEventInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceEventInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceEvent(int value) {
            VkDeviceEventInfoEXT.ndeviceEvent(this.address(), value);
            return this;
        }
    }
}

