/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupBindSparseInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RESOURCEDEVICEINDEX;
    public static final int MEMORYDEVICEINDEX;

    VkDeviceGroupBindSparseInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupBindSparseInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupBindSparseInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceGroupBindSparseInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceGroupBindSparseInfoKHX.npNext(this.address());
    }

    public int resourceDeviceIndex() {
        return VkDeviceGroupBindSparseInfoKHX.nresourceDeviceIndex(this.address());
    }

    public int memoryDeviceIndex() {
        return VkDeviceGroupBindSparseInfoKHX.nmemoryDeviceIndex(this.address());
    }

    public VkDeviceGroupBindSparseInfoKHX sType(int value) {
        VkDeviceGroupBindSparseInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHX pNext(long value) {
        VkDeviceGroupBindSparseInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHX resourceDeviceIndex(int value) {
        VkDeviceGroupBindSparseInfoKHX.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHX memoryDeviceIndex(int value) {
        VkDeviceGroupBindSparseInfoKHX.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHX set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHX set(VkDeviceGroupBindSparseInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfoKHX malloc() {
        return VkDeviceGroupBindSparseInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHX calloc() {
        return VkDeviceGroupBindSparseInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHX create() {
        return new VkDeviceGroupBindSparseInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHX create(long address) {
        return address == 0L ? null : new VkDeviceGroupBindSparseInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupBindSparseInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupBindSparseInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceGroupBindSparseInfoKHX mallocStack() {
        return VkDeviceGroupBindSparseInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfoKHX callocStack() {
        return VkDeviceGroupBindSparseInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfoKHX mallocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHX callocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nresourceDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESOURCEDEVICEINDEX);
    }

    public static int nmemoryDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYDEVICEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nresourceDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESOURCEDEVICEINDEX, value);
    }

    public static void nmemoryDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYDEVICEINDEX, value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupBindSparseInfoKHX.__struct(VkDeviceGroupBindSparseInfoKHX.__member(4), VkDeviceGroupBindSparseInfoKHX.__member(POINTER_SIZE), VkDeviceGroupBindSparseInfoKHX.__member(4), VkDeviceGroupBindSparseInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RESOURCEDEVICEINDEX = layout.offsetof(2);
        MEMORYDEVICEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupBindSparseInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupBindSparseInfoKHX newInstance(long address) {
            return new VkDeviceGroupBindSparseInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceGroupBindSparseInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceGroupBindSparseInfoKHX.npNext(this.address());
        }

        public int resourceDeviceIndex() {
            return VkDeviceGroupBindSparseInfoKHX.nresourceDeviceIndex(this.address());
        }

        public int memoryDeviceIndex() {
            return VkDeviceGroupBindSparseInfoKHX.nmemoryDeviceIndex(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceGroupBindSparseInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceGroupBindSparseInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer resourceDeviceIndex(int value) {
            VkDeviceGroupBindSparseInfoKHX.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        public Buffer memoryDeviceIndex(int value) {
            VkDeviceGroupBindSparseInfoKHX.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

