/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupDeviceCreateInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PPHYSICALDEVICES;

    VkDeviceGroupDeviceCreateInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupDeviceCreateInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupDeviceCreateInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceGroupDeviceCreateInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceGroupDeviceCreateInfoKHX.npNext(this.address());
    }

    public int physicalDeviceCount() {
        return VkDeviceGroupDeviceCreateInfoKHX.nphysicalDeviceCount(this.address());
    }

    public PointerBuffer pPhysicalDevices() {
        return VkDeviceGroupDeviceCreateInfoKHX.npPhysicalDevices(this.address());
    }

    public VkDeviceGroupDeviceCreateInfoKHX sType(int value) {
        VkDeviceGroupDeviceCreateInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfoKHX pNext(long value) {
        VkDeviceGroupDeviceCreateInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfoKHX pPhysicalDevices(PointerBuffer value) {
        VkDeviceGroupDeviceCreateInfoKHX.npPhysicalDevices(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfoKHX set(int sType, long pNext, PointerBuffer pPhysicalDevices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPhysicalDevices(pPhysicalDevices);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfoKHX set(VkDeviceGroupDeviceCreateInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupDeviceCreateInfoKHX malloc() {
        return VkDeviceGroupDeviceCreateInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHX calloc() {
        return VkDeviceGroupDeviceCreateInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHX create() {
        return new VkDeviceGroupDeviceCreateInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHX create(long address) {
        return address == 0L ? null : new VkDeviceGroupDeviceCreateInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceGroupDeviceCreateInfoKHX mallocStack() {
        return VkDeviceGroupDeviceCreateInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfoKHX callocStack() {
        return VkDeviceGroupDeviceCreateInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfoKHX mallocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHX callocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nphysicalDeviceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PHYSICALDEVICECOUNT);
    }

    public static PointerBuffer npPhysicalDevices(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)PPHYSICALDEVICES), VkDeviceGroupDeviceCreateInfoKHX.nphysicalDeviceCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nphysicalDeviceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PHYSICALDEVICECOUNT, value);
    }

    public static void npPhysicalDevices(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPHYSICALDEVICES, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupDeviceCreateInfoKHX.nphysicalDeviceCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupDeviceCreateInfoKHX.nphysicalDeviceCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPHYSICALDEVICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupDeviceCreateInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupDeviceCreateInfoKHX.__struct(VkDeviceGroupDeviceCreateInfoKHX.__member(4), VkDeviceGroupDeviceCreateInfoKHX.__member(POINTER_SIZE), VkDeviceGroupDeviceCreateInfoKHX.__member(4), VkDeviceGroupDeviceCreateInfoKHX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PPHYSICALDEVICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupDeviceCreateInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupDeviceCreateInfoKHX newInstance(long address) {
            return new VkDeviceGroupDeviceCreateInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceGroupDeviceCreateInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceGroupDeviceCreateInfoKHX.npNext(this.address());
        }

        public int physicalDeviceCount() {
            return VkDeviceGroupDeviceCreateInfoKHX.nphysicalDeviceCount(this.address());
        }

        public PointerBuffer pPhysicalDevices() {
            return VkDeviceGroupDeviceCreateInfoKHX.npPhysicalDevices(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceGroupDeviceCreateInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceGroupDeviceCreateInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer pPhysicalDevices(PointerBuffer value) {
            VkDeviceGroupDeviceCreateInfoKHX.npPhysicalDevices(this.address(), value);
            return this;
        }
    }
}

