/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupPresentCapabilitiesKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRESENTMASK;
    public static final int MODES;

    VkDeviceGroupPresentCapabilitiesKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupPresentCapabilitiesKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupPresentCapabilitiesKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceGroupPresentCapabilitiesKHX.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceGroupPresentCapabilitiesKHX.npNext(this.address());
    }

    public IntBuffer presentMask() {
        return VkDeviceGroupPresentCapabilitiesKHX.npresentMask(this.address());
    }

    public int presentMask(int index) {
        return VkDeviceGroupPresentCapabilitiesKHX.npresentMask(this.address(), index);
    }

    public int modes() {
        return VkDeviceGroupPresentCapabilitiesKHX.nmodes(this.address());
    }

    public static VkDeviceGroupPresentCapabilitiesKHX malloc() {
        return VkDeviceGroupPresentCapabilitiesKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHX calloc() {
        return VkDeviceGroupPresentCapabilitiesKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHX create() {
        return new VkDeviceGroupPresentCapabilitiesKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHX create(long address) {
        return address == 0L ? null : new VkDeviceGroupPresentCapabilitiesKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceGroupPresentCapabilitiesKHX mallocStack() {
        return VkDeviceGroupPresentCapabilitiesKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentCapabilitiesKHX callocStack() {
        return VkDeviceGroupPresentCapabilitiesKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentCapabilitiesKHX mallocStack(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupPresentCapabilitiesKHX callocStack(MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupPresentCapabilitiesKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentCapabilitiesKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static IntBuffer npresentMask(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)PRESENTMASK, 32);
    }

    public static int npresentMask(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 32);
        }
        return MemoryUtil.memGetInt(struct + (long)PRESENTMASK + (long)(index * 4));
    }

    public static int nmodes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODES);
    }

    static {
        Struct.Layout layout = VkDeviceGroupPresentCapabilitiesKHX.__struct(VkDeviceGroupPresentCapabilitiesKHX.__member(4), VkDeviceGroupPresentCapabilitiesKHX.__member(POINTER_SIZE), VkDeviceGroupPresentCapabilitiesKHX.__array(4, 32), VkDeviceGroupPresentCapabilitiesKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRESENTMASK = layout.offsetof(2);
        MODES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupPresentCapabilitiesKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupPresentCapabilitiesKHX newInstance(long address) {
            return new VkDeviceGroupPresentCapabilitiesKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceGroupPresentCapabilitiesKHX.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceGroupPresentCapabilitiesKHX.npNext(this.address());
        }

        public IntBuffer presentMask() {
            return VkDeviceGroupPresentCapabilitiesKHX.npresentMask(this.address());
        }

        public int presentMask(int index) {
            return VkDeviceGroupPresentCapabilitiesKHX.npresentMask(this.address(), index);
        }

        public int modes() {
            return VkDeviceGroupPresentCapabilitiesKHX.nmodes(this.address());
        }
    }
}

