/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupPresentInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SWAPCHAINCOUNT;
    public static final int PDEVICEMASKS;
    public static final int MODE;

    VkDeviceGroupPresentInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupPresentInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupPresentInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceGroupPresentInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceGroupPresentInfoKHX.npNext(this.address());
    }

    public int swapchainCount() {
        return VkDeviceGroupPresentInfoKHX.nswapchainCount(this.address());
    }

    public IntBuffer pDeviceMasks() {
        return VkDeviceGroupPresentInfoKHX.npDeviceMasks(this.address());
    }

    public int mode() {
        return VkDeviceGroupPresentInfoKHX.nmode(this.address());
    }

    public VkDeviceGroupPresentInfoKHX sType(int value) {
        VkDeviceGroupPresentInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHX pNext(long value) {
        VkDeviceGroupPresentInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHX pDeviceMasks(IntBuffer value) {
        VkDeviceGroupPresentInfoKHX.npDeviceMasks(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHX mode(int value) {
        VkDeviceGroupPresentInfoKHX.nmode(this.address(), value);
        return this;
    }

    public VkDeviceGroupPresentInfoKHX set(int sType, long pNext, IntBuffer pDeviceMasks, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceMasks(pDeviceMasks);
        this.mode(mode);
        return this;
    }

    public VkDeviceGroupPresentInfoKHX set(VkDeviceGroupPresentInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupPresentInfoKHX malloc() {
        return VkDeviceGroupPresentInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHX calloc() {
        return VkDeviceGroupPresentInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHX create() {
        return new VkDeviceGroupPresentInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHX create(long address) {
        return address == 0L ? null : new VkDeviceGroupPresentInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupPresentInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupPresentInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceGroupPresentInfoKHX mallocStack() {
        return VkDeviceGroupPresentInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentInfoKHX callocStack() {
        return VkDeviceGroupPresentInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupPresentInfoKHX mallocStack(MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupPresentInfoKHX callocStack(MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupPresentInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupPresentInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupPresentInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nswapchainCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SWAPCHAINCOUNT);
    }

    public static IntBuffer npDeviceMasks(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PDEVICEMASKS), VkDeviceGroupPresentInfoKHX.nswapchainCount(struct));
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nswapchainCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SWAPCHAINCOUNT, value);
    }

    public static void npDeviceMasks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEMASKS, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupPresentInfoKHX.nswapchainCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MODE, value);
    }

    public static void validate(long struct) {
        if (VkDeviceGroupPresentInfoKHX.nswapchainCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICEMASKS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupPresentInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupPresentInfoKHX.__struct(VkDeviceGroupPresentInfoKHX.__member(4), VkDeviceGroupPresentInfoKHX.__member(POINTER_SIZE), VkDeviceGroupPresentInfoKHX.__member(4), VkDeviceGroupPresentInfoKHX.__member(POINTER_SIZE), VkDeviceGroupPresentInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SWAPCHAINCOUNT = layout.offsetof(2);
        PDEVICEMASKS = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupPresentInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupPresentInfoKHX newInstance(long address) {
            return new VkDeviceGroupPresentInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceGroupPresentInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceGroupPresentInfoKHX.npNext(this.address());
        }

        public int swapchainCount() {
            return VkDeviceGroupPresentInfoKHX.nswapchainCount(this.address());
        }

        public IntBuffer pDeviceMasks() {
            return VkDeviceGroupPresentInfoKHX.npDeviceMasks(this.address());
        }

        public int mode() {
            return VkDeviceGroupPresentInfoKHX.nmode(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceGroupPresentInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceGroupPresentInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer pDeviceMasks(IntBuffer value) {
            VkDeviceGroupPresentInfoKHX.npDeviceMasks(this.address(), value);
            return this;
        }

        public Buffer mode(int value) {
            VkDeviceGroupPresentInfoKHX.nmode(this.address(), value);
            return this;
        }
    }
}

