/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDeviceGroupRenderPassBeginInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEMASK;
    public static final int DEVICERENDERAREACOUNT;
    public static final int PDEVICERENDERAREAS;

    VkDeviceGroupRenderPassBeginInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupRenderPassBeginInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupRenderPassBeginInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceGroupRenderPassBeginInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceGroupRenderPassBeginInfoKHX.npNext(this.address());
    }

    public int deviceMask() {
        return VkDeviceGroupRenderPassBeginInfoKHX.ndeviceMask(this.address());
    }

    public int deviceRenderAreaCount() {
        return VkDeviceGroupRenderPassBeginInfoKHX.ndeviceRenderAreaCount(this.address());
    }

    public VkRect2D.Buffer pDeviceRenderAreas() {
        return VkDeviceGroupRenderPassBeginInfoKHX.npDeviceRenderAreas(this.address());
    }

    public VkDeviceGroupRenderPassBeginInfoKHX sType(int value) {
        VkDeviceGroupRenderPassBeginInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfoKHX pNext(long value) {
        VkDeviceGroupRenderPassBeginInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfoKHX deviceMask(int value) {
        VkDeviceGroupRenderPassBeginInfoKHX.ndeviceMask(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfoKHX pDeviceRenderAreas(VkRect2D.Buffer value) {
        VkDeviceGroupRenderPassBeginInfoKHX.npDeviceRenderAreas(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfoKHX set(int sType, long pNext, int deviceMask, VkRect2D.Buffer pDeviceRenderAreas) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceMask(deviceMask);
        this.pDeviceRenderAreas(pDeviceRenderAreas);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfoKHX set(VkDeviceGroupRenderPassBeginInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX malloc() {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX calloc() {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX create() {
        return new VkDeviceGroupRenderPassBeginInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX create(long address) {
        return address == 0L ? null : new VkDeviceGroupRenderPassBeginInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX mallocStack() {
        return VkDeviceGroupRenderPassBeginInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX callocStack() {
        return VkDeviceGroupRenderPassBeginInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX mallocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupRenderPassBeginInfoKHX callocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMASK);
    }

    public static int ndeviceRenderAreaCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICERENDERAREACOUNT);
    }

    public static VkRect2D.Buffer npDeviceRenderAreas(long struct) {
        return VkRect2D.create(MemoryUtil.memGetAddress(struct + (long)PDEVICERENDERAREAS), VkDeviceGroupRenderPassBeginInfoKHX.ndeviceRenderAreaCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEMASK, value);
    }

    public static void ndeviceRenderAreaCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICERENDERAREACOUNT, value);
    }

    public static void npDeviceRenderAreas(long struct, VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICERENDERAREAS, VkDeviceGroupRenderPassBeginInfoKHX.addressSafe(value));
        VkDeviceGroupRenderPassBeginInfoKHX.ndeviceRenderAreaCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupRenderPassBeginInfoKHX.ndeviceRenderAreaCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICERENDERAREAS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupRenderPassBeginInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupRenderPassBeginInfoKHX.__struct(VkDeviceGroupRenderPassBeginInfoKHX.__member(4), VkDeviceGroupRenderPassBeginInfoKHX.__member(POINTER_SIZE), VkDeviceGroupRenderPassBeginInfoKHX.__member(4), VkDeviceGroupRenderPassBeginInfoKHX.__member(4), VkDeviceGroupRenderPassBeginInfoKHX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEMASK = layout.offsetof(2);
        DEVICERENDERAREACOUNT = layout.offsetof(3);
        PDEVICERENDERAREAS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupRenderPassBeginInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupRenderPassBeginInfoKHX newInstance(long address) {
            return new VkDeviceGroupRenderPassBeginInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceGroupRenderPassBeginInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceGroupRenderPassBeginInfoKHX.npNext(this.address());
        }

        public int deviceMask() {
            return VkDeviceGroupRenderPassBeginInfoKHX.ndeviceMask(this.address());
        }

        public int deviceRenderAreaCount() {
            return VkDeviceGroupRenderPassBeginInfoKHX.ndeviceRenderAreaCount(this.address());
        }

        public VkRect2D.Buffer pDeviceRenderAreas() {
            return VkDeviceGroupRenderPassBeginInfoKHX.npDeviceRenderAreas(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceGroupRenderPassBeginInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceGroupRenderPassBeginInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceMask(int value) {
            VkDeviceGroupRenderPassBeginInfoKHX.ndeviceMask(this.address(), value);
            return this;
        }

        public Buffer pDeviceRenderAreas(VkRect2D.Buffer value) {
            VkDeviceGroupRenderPassBeginInfoKHX.npDeviceRenderAreas(this.address(), value);
            return this;
        }
    }
}

