/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupSubmitInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHOREDEVICEINDICES;
    public static final int COMMANDBUFFERCOUNT;
    public static final int PCOMMANDBUFFERDEVICEMASKS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHOREDEVICEINDICES;

    VkDeviceGroupSubmitInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupSubmitInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupSubmitInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDeviceGroupSubmitInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkDeviceGroupSubmitInfoKHX.npNext(this.address());
    }

    public int waitSemaphoreCount() {
        return VkDeviceGroupSubmitInfoKHX.nwaitSemaphoreCount(this.address());
    }

    public IntBuffer pWaitSemaphoreDeviceIndices() {
        return VkDeviceGroupSubmitInfoKHX.npWaitSemaphoreDeviceIndices(this.address());
    }

    public int commandBufferCount() {
        return VkDeviceGroupSubmitInfoKHX.ncommandBufferCount(this.address());
    }

    public IntBuffer pCommandBufferDeviceMasks() {
        return VkDeviceGroupSubmitInfoKHX.npCommandBufferDeviceMasks(this.address());
    }

    public int signalSemaphoreCount() {
        return VkDeviceGroupSubmitInfoKHX.nsignalSemaphoreCount(this.address());
    }

    public IntBuffer pSignalSemaphoreDeviceIndices() {
        return VkDeviceGroupSubmitInfoKHX.npSignalSemaphoreDeviceIndices(this.address());
    }

    public VkDeviceGroupSubmitInfoKHX sType(int value) {
        VkDeviceGroupSubmitInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfoKHX pNext(long value) {
        VkDeviceGroupSubmitInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfoKHX pWaitSemaphoreDeviceIndices(IntBuffer value) {
        VkDeviceGroupSubmitInfoKHX.npWaitSemaphoreDeviceIndices(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfoKHX pCommandBufferDeviceMasks(IntBuffer value) {
        VkDeviceGroupSubmitInfoKHX.npCommandBufferDeviceMasks(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfoKHX pSignalSemaphoreDeviceIndices(IntBuffer value) {
        VkDeviceGroupSubmitInfoKHX.npSignalSemaphoreDeviceIndices(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfoKHX set(int sType, long pNext, IntBuffer pWaitSemaphoreDeviceIndices, IntBuffer pCommandBufferDeviceMasks, IntBuffer pSignalSemaphoreDeviceIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pWaitSemaphoreDeviceIndices(pWaitSemaphoreDeviceIndices);
        this.pCommandBufferDeviceMasks(pCommandBufferDeviceMasks);
        this.pSignalSemaphoreDeviceIndices(pSignalSemaphoreDeviceIndices);
        return this;
    }

    public VkDeviceGroupSubmitInfoKHX set(VkDeviceGroupSubmitInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupSubmitInfoKHX malloc() {
        return VkDeviceGroupSubmitInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDeviceGroupSubmitInfoKHX calloc() {
        return VkDeviceGroupSubmitInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDeviceGroupSubmitInfoKHX create() {
        return new VkDeviceGroupSubmitInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupSubmitInfoKHX create(long address) {
        return address == 0L ? null : new VkDeviceGroupSubmitInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupSubmitInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupSubmitInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDeviceGroupSubmitInfoKHX mallocStack() {
        return VkDeviceGroupSubmitInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupSubmitInfoKHX callocStack() {
        return VkDeviceGroupSubmitInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupSubmitInfoKHX mallocStack(MemoryStack stack) {
        return VkDeviceGroupSubmitInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupSubmitInfoKHX callocStack(MemoryStack stack) {
        return VkDeviceGroupSubmitInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupSubmitInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupSubmitInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupSubmitInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupSubmitInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nwaitSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITSEMAPHORECOUNT);
    }

    public static IntBuffer npWaitSemaphoreDeviceIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHOREDEVICEINDICES), VkDeviceGroupSubmitInfoKHX.nwaitSemaphoreCount(struct));
    }

    public static int ncommandBufferCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMMANDBUFFERCOUNT);
    }

    public static IntBuffer npCommandBufferDeviceMasks(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERDEVICEMASKS), VkDeviceGroupSubmitInfoKHX.ncommandBufferCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIGNALSEMAPHORECOUNT);
    }

    public static IntBuffer npSignalSemaphoreDeviceIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHOREDEVICEINDICES), VkDeviceGroupSubmitInfoKHX.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphoreDeviceIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHOREDEVICEINDICES, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupSubmitInfoKHX.nwaitSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncommandBufferCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMMANDBUFFERCOUNT, value);
    }

    public static void npCommandBufferDeviceMasks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOMMANDBUFFERDEVICEMASKS, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupSubmitInfoKHX.ncommandBufferCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIGNALSEMAPHORECOUNT, value);
    }

    public static void npSignalSemaphoreDeviceIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSIGNALSEMAPHOREDEVICEINDICES, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupSubmitInfoKHX.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupSubmitInfoKHX.nwaitSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHOREDEVICEINDICES));
        }
        if (VkDeviceGroupSubmitInfoKHX.ncommandBufferCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERDEVICEMASKS));
        }
        if (VkDeviceGroupSubmitInfoKHX.nsignalSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHOREDEVICEINDICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupSubmitInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupSubmitInfoKHX.__struct(VkDeviceGroupSubmitInfoKHX.__member(4), VkDeviceGroupSubmitInfoKHX.__member(POINTER_SIZE), VkDeviceGroupSubmitInfoKHX.__member(4), VkDeviceGroupSubmitInfoKHX.__member(POINTER_SIZE), VkDeviceGroupSubmitInfoKHX.__member(4), VkDeviceGroupSubmitInfoKHX.__member(POINTER_SIZE), VkDeviceGroupSubmitInfoKHX.__member(4), VkDeviceGroupSubmitInfoKHX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHOREDEVICEINDICES = layout.offsetof(3);
        COMMANDBUFFERCOUNT = layout.offsetof(4);
        PCOMMANDBUFFERDEVICEMASKS = layout.offsetof(5);
        SIGNALSEMAPHORECOUNT = layout.offsetof(6);
        PSIGNALSEMAPHOREDEVICEINDICES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupSubmitInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupSubmitInfoKHX newInstance(long address) {
            return new VkDeviceGroupSubmitInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDeviceGroupSubmitInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkDeviceGroupSubmitInfoKHX.npNext(this.address());
        }

        public int waitSemaphoreCount() {
            return VkDeviceGroupSubmitInfoKHX.nwaitSemaphoreCount(this.address());
        }

        public IntBuffer pWaitSemaphoreDeviceIndices() {
            return VkDeviceGroupSubmitInfoKHX.npWaitSemaphoreDeviceIndices(this.address());
        }

        public int commandBufferCount() {
            return VkDeviceGroupSubmitInfoKHX.ncommandBufferCount(this.address());
        }

        public IntBuffer pCommandBufferDeviceMasks() {
            return VkDeviceGroupSubmitInfoKHX.npCommandBufferDeviceMasks(this.address());
        }

        public int signalSemaphoreCount() {
            return VkDeviceGroupSubmitInfoKHX.nsignalSemaphoreCount(this.address());
        }

        public IntBuffer pSignalSemaphoreDeviceIndices() {
            return VkDeviceGroupSubmitInfoKHX.npSignalSemaphoreDeviceIndices(this.address());
        }

        public Buffer sType(int value) {
            VkDeviceGroupSubmitInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDeviceGroupSubmitInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphoreDeviceIndices(IntBuffer value) {
            VkDeviceGroupSubmitInfoKHX.npWaitSemaphoreDeviceIndices(this.address(), value);
            return this;
        }

        public Buffer pCommandBufferDeviceMasks(IntBuffer value) {
            VkDeviceGroupSubmitInfoKHX.npCommandBufferDeviceMasks(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphoreDeviceIndices(IntBuffer value) {
            VkDeviceGroupSubmitInfoKHX.npSignalSemaphoreDeviceIndices(this.address(), value);
            return this;
        }
    }
}

