/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDispatchIndirectCommand
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    VkDispatchIndirectCommand(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDispatchIndirectCommand(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDispatchIndirectCommand.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return VkDispatchIndirectCommand.nx(this.address());
    }

    public int y() {
        return VkDispatchIndirectCommand.ny(this.address());
    }

    public int z() {
        return VkDispatchIndirectCommand.nz(this.address());
    }

    public VkDispatchIndirectCommand x(int value) {
        VkDispatchIndirectCommand.nx(this.address(), value);
        return this;
    }

    public VkDispatchIndirectCommand y(int value) {
        VkDispatchIndirectCommand.ny(this.address(), value);
        return this;
    }

    public VkDispatchIndirectCommand z(int value) {
        VkDispatchIndirectCommand.nz(this.address(), value);
        return this;
    }

    public VkDispatchIndirectCommand set(int x, int y, int z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public VkDispatchIndirectCommand set(VkDispatchIndirectCommand src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDispatchIndirectCommand malloc() {
        return VkDispatchIndirectCommand.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDispatchIndirectCommand calloc() {
        return VkDispatchIndirectCommand.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDispatchIndirectCommand create() {
        return new VkDispatchIndirectCommand(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDispatchIndirectCommand create(long address) {
        return address == 0L ? null : new VkDispatchIndirectCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDispatchIndirectCommand.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDispatchIndirectCommand.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDispatchIndirectCommand mallocStack() {
        return VkDispatchIndirectCommand.mallocStack(MemoryStack.stackGet());
    }

    public static VkDispatchIndirectCommand callocStack() {
        return VkDispatchIndirectCommand.callocStack(MemoryStack.stackGet());
    }

    public static VkDispatchIndirectCommand mallocStack(MemoryStack stack) {
        return VkDispatchIndirectCommand.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDispatchIndirectCommand callocStack(MemoryStack stack) {
        return VkDispatchIndirectCommand.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDispatchIndirectCommand.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDispatchIndirectCommand.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDispatchIndirectCommand.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDispatchIndirectCommand.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Z);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = VkDispatchIndirectCommand.__struct(VkDispatchIndirectCommand.__member(4), VkDispatchIndirectCommand.__member(4), VkDispatchIndirectCommand.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDispatchIndirectCommand, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDispatchIndirectCommand newInstance(long address) {
            return new VkDispatchIndirectCommand(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return VkDispatchIndirectCommand.nx(this.address());
        }

        public int y() {
            return VkDispatchIndirectCommand.ny(this.address());
        }

        public int z() {
            return VkDispatchIndirectCommand.nz(this.address());
        }

        public Buffer x(int value) {
            VkDispatchIndirectCommand.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            VkDispatchIndirectCommand.ny(this.address(), value);
            return this;
        }

        public Buffer z(int value) {
            VkDispatchIndirectCommand.nz(this.address(), value);
            return this;
        }
    }
}

