/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDisplayModeParametersKHR;

public class VkDisplayModeCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PARAMETERS;

    VkDisplayModeCreateInfoKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayModeCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayModeCreateInfoKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDisplayModeCreateInfoKHR.nsType(this.address());
    }

    public long pNext() {
        return VkDisplayModeCreateInfoKHR.npNext(this.address());
    }

    public int flags() {
        return VkDisplayModeCreateInfoKHR.nflags(this.address());
    }

    public VkDisplayModeParametersKHR parameters() {
        return VkDisplayModeCreateInfoKHR.nparameters(this.address());
    }

    public VkDisplayModeCreateInfoKHR sType(int value) {
        VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR pNext(long value) {
        VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR flags(int value) {
        VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR parameters(VkDisplayModeParametersKHR value) {
        VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(int sType, long pNext, int flags, VkDisplayModeParametersKHR parameters) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.parameters(parameters);
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(VkDisplayModeCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDisplayModeCreateInfoKHR malloc() {
        return VkDisplayModeCreateInfoKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR calloc() {
        return VkDisplayModeCreateInfoKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR create() {
        return new VkDisplayModeCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR create(long address) {
        return address == 0L ? null : new VkDisplayModeCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayModeCreateInfoKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayModeCreateInfoKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDisplayModeCreateInfoKHR mallocStack() {
        return VkDisplayModeCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModeCreateInfoKHR callocStack() {
        return VkDisplayModeCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModeCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR callocStack(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static VkDisplayModeParametersKHR nparameters(long struct) {
        return VkDisplayModeParametersKHR.create(struct + (long)PARAMETERS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nparameters(long struct, VkDisplayModeParametersKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARAMETERS, VkDisplayModeParametersKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDisplayModeCreateInfoKHR.__struct(VkDisplayModeCreateInfoKHR.__member(4), VkDisplayModeCreateInfoKHR.__member(POINTER_SIZE), VkDisplayModeCreateInfoKHR.__member(4), VkDisplayModeCreateInfoKHR.__member(VkDisplayModeParametersKHR.SIZEOF, VkDisplayModeParametersKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PARAMETERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeCreateInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayModeCreateInfoKHR newInstance(long address) {
            return new VkDisplayModeCreateInfoKHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDisplayModeCreateInfoKHR.nsType(this.address());
        }

        public long pNext() {
            return VkDisplayModeCreateInfoKHR.npNext(this.address());
        }

        public int flags() {
            return VkDisplayModeCreateInfoKHR.nflags(this.address());
        }

        public VkDisplayModeParametersKHR parameters() {
            return VkDisplayModeCreateInfoKHR.nparameters(this.address());
        }

        public Buffer sType(int value) {
            VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer parameters(VkDisplayModeParametersKHR value) {
            VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
            return this;
        }
    }
}

