/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDrawIndexedIndirectCommand
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEXCOUNT;
    public static final int INSTANCECOUNT;
    public static final int FIRSTINDEX;
    public static final int VERTEXOFFSET;
    public static final int FIRSTINSTANCE;

    VkDrawIndexedIndirectCommand(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDrawIndexedIndirectCommand(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDrawIndexedIndirectCommand.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int indexCount() {
        return VkDrawIndexedIndirectCommand.nindexCount(this.address());
    }

    public int instanceCount() {
        return VkDrawIndexedIndirectCommand.ninstanceCount(this.address());
    }

    public int firstIndex() {
        return VkDrawIndexedIndirectCommand.nfirstIndex(this.address());
    }

    public int vertexOffset() {
        return VkDrawIndexedIndirectCommand.nvertexOffset(this.address());
    }

    public int firstInstance() {
        return VkDrawIndexedIndirectCommand.nfirstInstance(this.address());
    }

    public VkDrawIndexedIndirectCommand indexCount(int value) {
        VkDrawIndexedIndirectCommand.nindexCount(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand instanceCount(int value) {
        VkDrawIndexedIndirectCommand.ninstanceCount(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand firstIndex(int value) {
        VkDrawIndexedIndirectCommand.nfirstIndex(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand vertexOffset(int value) {
        VkDrawIndexedIndirectCommand.nvertexOffset(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand firstInstance(int value) {
        VkDrawIndexedIndirectCommand.nfirstInstance(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand set(int indexCount, int instanceCount, int firstIndex, int vertexOffset, int firstInstance) {
        this.indexCount(indexCount);
        this.instanceCount(instanceCount);
        this.firstIndex(firstIndex);
        this.vertexOffset(vertexOffset);
        this.firstInstance(firstInstance);
        return this;
    }

    public VkDrawIndexedIndirectCommand set(VkDrawIndexedIndirectCommand src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDrawIndexedIndirectCommand malloc() {
        return VkDrawIndexedIndirectCommand.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand calloc() {
        return VkDrawIndexedIndirectCommand.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand create() {
        return new VkDrawIndexedIndirectCommand(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand create(long address) {
        return address == 0L ? null : new VkDrawIndexedIndirectCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDrawIndexedIndirectCommand.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDrawIndexedIndirectCommand.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDrawIndexedIndirectCommand mallocStack() {
        return VkDrawIndexedIndirectCommand.mallocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndexedIndirectCommand callocStack() {
        return VkDrawIndexedIndirectCommand.callocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndexedIndirectCommand mallocStack(MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDrawIndexedIndirectCommand callocStack(MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDrawIndexedIndirectCommand.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDrawIndexedIndirectCommand.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nindexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXCOUNT);
    }

    public static int ninstanceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INSTANCECOUNT);
    }

    public static int nfirstIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTINDEX);
    }

    public static int nvertexOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXOFFSET);
    }

    public static int nfirstInstance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTINSTANCE);
    }

    public static void nindexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXCOUNT, value);
    }

    public static void ninstanceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INSTANCECOUNT, value);
    }

    public static void nfirstIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTINDEX, value);
    }

    public static void nvertexOffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXOFFSET, value);
    }

    public static void nfirstInstance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTINSTANCE, value);
    }

    static {
        Struct.Layout layout = VkDrawIndexedIndirectCommand.__struct(VkDrawIndexedIndirectCommand.__member(4), VkDrawIndexedIndirectCommand.__member(4), VkDrawIndexedIndirectCommand.__member(4), VkDrawIndexedIndirectCommand.__member(4), VkDrawIndexedIndirectCommand.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEXCOUNT = layout.offsetof(0);
        INSTANCECOUNT = layout.offsetof(1);
        FIRSTINDEX = layout.offsetof(2);
        VERTEXOFFSET = layout.offsetof(3);
        FIRSTINSTANCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDrawIndexedIndirectCommand, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDrawIndexedIndirectCommand newInstance(long address) {
            return new VkDrawIndexedIndirectCommand(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int indexCount() {
            return VkDrawIndexedIndirectCommand.nindexCount(this.address());
        }

        public int instanceCount() {
            return VkDrawIndexedIndirectCommand.ninstanceCount(this.address());
        }

        public int firstIndex() {
            return VkDrawIndexedIndirectCommand.nfirstIndex(this.address());
        }

        public int vertexOffset() {
            return VkDrawIndexedIndirectCommand.nvertexOffset(this.address());
        }

        public int firstInstance() {
            return VkDrawIndexedIndirectCommand.nfirstInstance(this.address());
        }

        public Buffer indexCount(int value) {
            VkDrawIndexedIndirectCommand.nindexCount(this.address(), value);
            return this;
        }

        public Buffer instanceCount(int value) {
            VkDrawIndexedIndirectCommand.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer firstIndex(int value) {
            VkDrawIndexedIndirectCommand.nfirstIndex(this.address(), value);
            return this;
        }

        public Buffer vertexOffset(int value) {
            VkDrawIndexedIndirectCommand.nvertexOffset(this.address(), value);
            return this;
        }

        public Buffer firstInstance(int value) {
            VkDrawIndexedIndirectCommand.nfirstInstance(this.address(), value);
            return this;
        }
    }
}

