/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDrawIndirectCommand
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEXCOUNT;
    public static final int INSTANCECOUNT;
    public static final int FIRSTVERTEX;
    public static final int FIRSTINSTANCE;

    VkDrawIndirectCommand(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDrawIndirectCommand(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDrawIndirectCommand.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int vertexCount() {
        return VkDrawIndirectCommand.nvertexCount(this.address());
    }

    public int instanceCount() {
        return VkDrawIndirectCommand.ninstanceCount(this.address());
    }

    public int firstVertex() {
        return VkDrawIndirectCommand.nfirstVertex(this.address());
    }

    public int firstInstance() {
        return VkDrawIndirectCommand.nfirstInstance(this.address());
    }

    public VkDrawIndirectCommand vertexCount(int value) {
        VkDrawIndirectCommand.nvertexCount(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand instanceCount(int value) {
        VkDrawIndirectCommand.ninstanceCount(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand firstVertex(int value) {
        VkDrawIndirectCommand.nfirstVertex(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand firstInstance(int value) {
        VkDrawIndirectCommand.nfirstInstance(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand set(int vertexCount, int instanceCount, int firstVertex, int firstInstance) {
        this.vertexCount(vertexCount);
        this.instanceCount(instanceCount);
        this.firstVertex(firstVertex);
        this.firstInstance(firstInstance);
        return this;
    }

    public VkDrawIndirectCommand set(VkDrawIndirectCommand src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDrawIndirectCommand malloc() {
        return VkDrawIndirectCommand.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDrawIndirectCommand calloc() {
        return VkDrawIndirectCommand.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDrawIndirectCommand create() {
        return new VkDrawIndirectCommand(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDrawIndirectCommand create(long address) {
        return address == 0L ? null : new VkDrawIndirectCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDrawIndirectCommand.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDrawIndirectCommand.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDrawIndirectCommand mallocStack() {
        return VkDrawIndirectCommand.mallocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndirectCommand callocStack() {
        return VkDrawIndirectCommand.callocStack(MemoryStack.stackGet());
    }

    public static VkDrawIndirectCommand mallocStack(MemoryStack stack) {
        return VkDrawIndirectCommand.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDrawIndirectCommand callocStack(MemoryStack stack) {
        return VkDrawIndirectCommand.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDrawIndirectCommand.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDrawIndirectCommand.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDrawIndirectCommand.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDrawIndirectCommand.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCOUNT);
    }

    public static int ninstanceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INSTANCECOUNT);
    }

    public static int nfirstVertex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTVERTEX);
    }

    public static int nfirstInstance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTINSTANCE);
    }

    public static void nvertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCOUNT, value);
    }

    public static void ninstanceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INSTANCECOUNT, value);
    }

    public static void nfirstVertex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTVERTEX, value);
    }

    public static void nfirstInstance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTINSTANCE, value);
    }

    static {
        Struct.Layout layout = VkDrawIndirectCommand.__struct(VkDrawIndirectCommand.__member(4), VkDrawIndirectCommand.__member(4), VkDrawIndirectCommand.__member(4), VkDrawIndirectCommand.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEXCOUNT = layout.offsetof(0);
        INSTANCECOUNT = layout.offsetof(1);
        FIRSTVERTEX = layout.offsetof(2);
        FIRSTINSTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDrawIndirectCommand, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDrawIndirectCommand newInstance(long address) {
            return new VkDrawIndirectCommand(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int vertexCount() {
            return VkDrawIndirectCommand.nvertexCount(this.address());
        }

        public int instanceCount() {
            return VkDrawIndirectCommand.ninstanceCount(this.address());
        }

        public int firstVertex() {
            return VkDrawIndirectCommand.nfirstVertex(this.address());
        }

        public int firstInstance() {
            return VkDrawIndirectCommand.nfirstInstance(this.address());
        }

        public Buffer vertexCount(int value) {
            VkDrawIndirectCommand.nvertexCount(this.address(), value);
            return this;
        }

        public Buffer instanceCount(int value) {
            VkDrawIndirectCommand.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer firstVertex(int value) {
            VkDrawIndirectCommand.nfirstVertex(this.address(), value);
            return this;
        }

        public Buffer firstInstance(int value) {
            VkDrawIndirectCommand.nfirstInstance(this.address(), value);
            return this;
        }
    }
}

