/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportMemoryAllocateInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExportMemoryAllocateInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExportMemoryAllocateInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportMemoryAllocateInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkExportMemoryAllocateInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkExportMemoryAllocateInfoKHX.npNext(this.address());
    }

    public int handleTypes() {
        return VkExportMemoryAllocateInfoKHX.nhandleTypes(this.address());
    }

    public VkExportMemoryAllocateInfoKHX sType(int value) {
        VkExportMemoryAllocateInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoKHX pNext(long value) {
        VkExportMemoryAllocateInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoKHX handleTypes(int value) {
        VkExportMemoryAllocateInfoKHX.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoKHX set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfoKHX set(VkExportMemoryAllocateInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfoKHX malloc() {
        return VkExportMemoryAllocateInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHX calloc() {
        return VkExportMemoryAllocateInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHX create() {
        return new VkExportMemoryAllocateInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHX create(long address) {
        return address == 0L ? null : new VkExportMemoryAllocateInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExportMemoryAllocateInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportMemoryAllocateInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExportMemoryAllocateInfoKHX mallocStack() {
        return VkExportMemoryAllocateInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfoKHX callocStack() {
        return VkExportMemoryAllocateInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfoKHX mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHX callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportMemoryAllocateInfoKHX.__struct(VkExportMemoryAllocateInfoKHX.__member(4), VkExportMemoryAllocateInfoKHX.__member(POINTER_SIZE), VkExportMemoryAllocateInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryAllocateInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportMemoryAllocateInfoKHX newInstance(long address) {
            return new VkExportMemoryAllocateInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkExportMemoryAllocateInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkExportMemoryAllocateInfoKHX.npNext(this.address());
        }

        public int handleTypes() {
            return VkExportMemoryAllocateInfoKHX.nhandleTypes(this.address());
        }

        public Buffer sType(int value) {
            VkExportMemoryAllocateInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkExportMemoryAllocateInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(int value) {
            VkExportMemoryAllocateInfoKHX.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

