/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    VkExtent2D(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExtent2D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExtent2D.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return VkExtent2D.nwidth(this.address());
    }

    public int height() {
        return VkExtent2D.nheight(this.address());
    }

    public VkExtent2D width(int value) {
        VkExtent2D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent2D height(int value) {
        VkExtent2D.nheight(this.address(), value);
        return this;
    }

    public VkExtent2D set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public VkExtent2D set(VkExtent2D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExtent2D malloc() {
        return VkExtent2D.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExtent2D calloc() {
        return VkExtent2D.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExtent2D create() {
        return new VkExtent2D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExtent2D create(long address) {
        return address == 0L ? null : new VkExtent2D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExtent2D.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExtent2D.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExtent2D mallocStack() {
        return VkExtent2D.mallocStack(MemoryStack.stackGet());
    }

    public static VkExtent2D callocStack() {
        return VkExtent2D.callocStack(MemoryStack.stackGet());
    }

    public static VkExtent2D mallocStack(MemoryStack stack) {
        return VkExtent2D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtent2D callocStack(MemoryStack stack) {
        return VkExtent2D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExtent2D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExtent2D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtent2D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtent2D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = VkExtent2D.__struct(VkExtent2D.__member(4), VkExtent2D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkExtent2D, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExtent2D newInstance(long address) {
            return new VkExtent2D(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int width() {
            return VkExtent2D.nwidth(this.address());
        }

        public int height() {
            return VkExtent2D.nheight(this.address());
        }

        public Buffer width(int value) {
            VkExtent2D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            VkExtent2D.nheight(this.address(), value);
            return this;
        }
    }
}

