/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryPropertiesKHX;

public class VkExternalBufferPropertiesKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int EXTERNALMEMORYPROPERTIES;

    VkExternalBufferPropertiesKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExternalBufferPropertiesKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalBufferPropertiesKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkExternalBufferPropertiesKHX.nsType(this.address());
    }

    public long pNext() {
        return VkExternalBufferPropertiesKHX.npNext(this.address());
    }

    public VkExternalMemoryPropertiesKHX externalMemoryProperties() {
        return VkExternalBufferPropertiesKHX.nexternalMemoryProperties(this.address());
    }

    public static VkExternalBufferPropertiesKHX malloc() {
        return VkExternalBufferPropertiesKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExternalBufferPropertiesKHX calloc() {
        return VkExternalBufferPropertiesKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExternalBufferPropertiesKHX create() {
        return new VkExternalBufferPropertiesKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalBufferPropertiesKHX create(long address) {
        return address == 0L ? null : new VkExternalBufferPropertiesKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalBufferPropertiesKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalBufferPropertiesKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExternalBufferPropertiesKHX mallocStack() {
        return VkExternalBufferPropertiesKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferPropertiesKHX callocStack() {
        return VkExternalBufferPropertiesKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferPropertiesKHX mallocStack(MemoryStack stack) {
        return VkExternalBufferPropertiesKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalBufferPropertiesKHX callocStack(MemoryStack stack) {
        return VkExternalBufferPropertiesKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalBufferPropertiesKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalBufferPropertiesKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferPropertiesKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferPropertiesKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkExternalMemoryPropertiesKHX nexternalMemoryProperties(long struct) {
        return VkExternalMemoryPropertiesKHX.create(struct + (long)EXTERNALMEMORYPROPERTIES);
    }

    static {
        Struct.Layout layout = VkExternalBufferPropertiesKHX.__struct(VkExternalBufferPropertiesKHX.__member(4), VkExternalBufferPropertiesKHX.__member(POINTER_SIZE), VkExternalBufferPropertiesKHX.__member(VkExternalMemoryPropertiesKHX.SIZEOF, VkExternalMemoryPropertiesKHX.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        EXTERNALMEMORYPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalBufferPropertiesKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalBufferPropertiesKHX newInstance(long address) {
            return new VkExternalBufferPropertiesKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkExternalBufferPropertiesKHX.nsType(this.address());
        }

        public long pNext() {
            return VkExternalBufferPropertiesKHX.npNext(this.address());
        }

        public VkExternalMemoryPropertiesKHX externalMemoryProperties() {
            return VkExternalBufferPropertiesKHX.nexternalMemoryProperties(this.address());
        }
    }
}

