/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageFormatProperties;

public class VkExternalImageFormatPropertiesNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGEFORMATPROPERTIES;
    public static final int EXTERNALMEMORYFEATURES;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;

    VkExternalImageFormatPropertiesNV(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExternalImageFormatPropertiesNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalImageFormatPropertiesNV.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageFormatProperties imageFormatProperties() {
        return VkExternalImageFormatPropertiesNV.nimageFormatProperties(this.address());
    }

    public int externalMemoryFeatures() {
        return VkExternalImageFormatPropertiesNV.nexternalMemoryFeatures(this.address());
    }

    public int exportFromImportedHandleTypes() {
        return VkExternalImageFormatPropertiesNV.nexportFromImportedHandleTypes(this.address());
    }

    public int compatibleHandleTypes() {
        return VkExternalImageFormatPropertiesNV.ncompatibleHandleTypes(this.address());
    }

    public static VkExternalImageFormatPropertiesNV malloc() {
        return VkExternalImageFormatPropertiesNV.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV calloc() {
        return VkExternalImageFormatPropertiesNV.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV create() {
        return new VkExternalImageFormatPropertiesNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV create(long address) {
        return address == 0L ? null : new VkExternalImageFormatPropertiesNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalImageFormatPropertiesNV.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalImageFormatPropertiesNV.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExternalImageFormatPropertiesNV mallocStack() {
        return VkExternalImageFormatPropertiesNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalImageFormatPropertiesNV callocStack() {
        return VkExternalImageFormatPropertiesNV.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalImageFormatPropertiesNV mallocStack(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV callocStack(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalImageFormatPropertiesNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalImageFormatPropertiesNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageFormatProperties nimageFormatProperties(long struct) {
        return VkImageFormatProperties.create(struct + (long)IMAGEFORMATPROPERTIES);
    }

    public static int nexternalMemoryFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTERNALMEMORYFEATURES);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPATIBLEHANDLETYPES);
    }

    static {
        Struct.Layout layout = VkExternalImageFormatPropertiesNV.__struct(VkExternalImageFormatPropertiesNV.__member(VkImageFormatProperties.SIZEOF, VkImageFormatProperties.ALIGNOF), VkExternalImageFormatPropertiesNV.__member(4), VkExternalImageFormatPropertiesNV.__member(4), VkExternalImageFormatPropertiesNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGEFORMATPROPERTIES = layout.offsetof(0);
        EXTERNALMEMORYFEATURES = layout.offsetof(1);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(2);
        COMPATIBLEHANDLETYPES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkExternalImageFormatPropertiesNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalImageFormatPropertiesNV newInstance(long address) {
            return new VkExternalImageFormatPropertiesNV(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkImageFormatProperties imageFormatProperties() {
            return VkExternalImageFormatPropertiesNV.nimageFormatProperties(this.address());
        }

        public int externalMemoryFeatures() {
            return VkExternalImageFormatPropertiesNV.nexternalMemoryFeatures(this.address());
        }

        public int exportFromImportedHandleTypes() {
            return VkExternalImageFormatPropertiesNV.nexportFromImportedHandleTypes(this.address());
        }

        public int compatibleHandleTypes() {
            return VkExternalImageFormatPropertiesNV.ncompatibleHandleTypes(this.address());
        }
    }
}

