/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryBufferCreateInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExternalMemoryBufferCreateInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryBufferCreateInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryBufferCreateInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkExternalMemoryBufferCreateInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkExternalMemoryBufferCreateInfoKHX.npNext(this.address());
    }

    public int handleTypes() {
        return VkExternalMemoryBufferCreateInfoKHX.nhandleTypes(this.address());
    }

    public VkExternalMemoryBufferCreateInfoKHX sType(int value) {
        VkExternalMemoryBufferCreateInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHX pNext(long value) {
        VkExternalMemoryBufferCreateInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHX handleTypes(int value) {
        VkExternalMemoryBufferCreateInfoKHX.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHX set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHX set(VkExternalMemoryBufferCreateInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfoKHX malloc() {
        return VkExternalMemoryBufferCreateInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHX calloc() {
        return VkExternalMemoryBufferCreateInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHX create() {
        return new VkExternalMemoryBufferCreateInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHX create(long address) {
        return address == 0L ? null : new VkExternalMemoryBufferCreateInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExternalMemoryBufferCreateInfoKHX mallocStack() {
        return VkExternalMemoryBufferCreateInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfoKHX callocStack() {
        return VkExternalMemoryBufferCreateInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfoKHX mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHX callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryBufferCreateInfoKHX.__struct(VkExternalMemoryBufferCreateInfoKHX.__member(4), VkExternalMemoryBufferCreateInfoKHX.__member(POINTER_SIZE), VkExternalMemoryBufferCreateInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryBufferCreateInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryBufferCreateInfoKHX newInstance(long address) {
            return new VkExternalMemoryBufferCreateInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkExternalMemoryBufferCreateInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkExternalMemoryBufferCreateInfoKHX.npNext(this.address());
        }

        public int handleTypes() {
            return VkExternalMemoryBufferCreateInfoKHX.nhandleTypes(this.address());
        }

        public Buffer sType(int value) {
            VkExternalMemoryBufferCreateInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkExternalMemoryBufferCreateInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(int value) {
            VkExternalMemoryBufferCreateInfoKHX.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

