/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryImageCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExternalMemoryImageCreateInfoNV(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryImageCreateInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryImageCreateInfoNV.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkExternalMemoryImageCreateInfoNV.nsType(this.address());
    }

    public long pNext() {
        return VkExternalMemoryImageCreateInfoNV.npNext(this.address());
    }

    public int handleTypes() {
        return VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address());
    }

    public VkExternalMemoryImageCreateInfoNV sType(int value) {
        VkExternalMemoryImageCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV pNext(long value) {
        VkExternalMemoryImageCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV handleTypes(int value) {
        VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV set(VkExternalMemoryImageCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfoNV malloc() {
        return VkExternalMemoryImageCreateInfoNV.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoNV calloc() {
        return VkExternalMemoryImageCreateInfoNV.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoNV create() {
        return new VkExternalMemoryImageCreateInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoNV create(long address) {
        return address == 0L ? null : new VkExternalMemoryImageCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryImageCreateInfoNV.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryImageCreateInfoNV.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkExternalMemoryImageCreateInfoNV mallocStack() {
        return VkExternalMemoryImageCreateInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfoNV callocStack() {
        return VkExternalMemoryImageCreateInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfoNV mallocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoNV callocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryImageCreateInfoNV.__struct(VkExternalMemoryImageCreateInfoNV.__member(4), VkExternalMemoryImageCreateInfoNV.__member(POINTER_SIZE), VkExternalMemoryImageCreateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryImageCreateInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryImageCreateInfoNV newInstance(long address) {
            return new VkExternalMemoryImageCreateInfoNV(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkExternalMemoryImageCreateInfoNV.nsType(this.address());
        }

        public long pNext() {
            return VkExternalMemoryImageCreateInfoNV.npNext(this.address());
        }

        public int handleTypes() {
            return VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address());
        }

        public Buffer sType(int value) {
            VkExternalMemoryImageCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkExternalMemoryImageCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(int value) {
            VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

