/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryPropertiesKHX
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTERNALMEMORYFEATURES;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;

    VkExternalMemoryPropertiesKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryPropertiesKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryPropertiesKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int externalMemoryFeatures() {
        return VkExternalMemoryPropertiesKHX.nexternalMemoryFeatures(this.address());
    }

    public int exportFromImportedHandleTypes() {
        return VkExternalMemoryPropertiesKHX.nexportFromImportedHandleTypes(this.address());
    }

    public int compatibleHandleTypes() {
        return VkExternalMemoryPropertiesKHX.ncompatibleHandleTypes(this.address());
    }

    public static VkExternalMemoryPropertiesKHX create(long address) {
        return address == 0L ? null : new VkExternalMemoryPropertiesKHX(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nexternalMemoryFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTERNALMEMORYFEATURES);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPATIBLEHANDLETYPES);
    }

    static {
        Struct.Layout layout = VkExternalMemoryPropertiesKHX.__struct(VkExternalMemoryPropertiesKHX.__member(4), VkExternalMemoryPropertiesKHX.__member(4), VkExternalMemoryPropertiesKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTERNALMEMORYFEATURES = layout.offsetof(0);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(1);
        COMPATIBLEHANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryPropertiesKHX, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryPropertiesKHX newInstance(long address) {
            return new VkExternalMemoryPropertiesKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int externalMemoryFeatures() {
            return VkExternalMemoryPropertiesKHX.nexternalMemoryFeatures(this.address());
        }

        public int exportFromImportedHandleTypes() {
            return VkExternalMemoryPropertiesKHX.nexportFromImportedHandleTypes(this.address());
        }

        public int compatibleHandleTypes() {
            return VkExternalMemoryPropertiesKHX.ncompatibleHandleTypes(this.address());
        }
    }
}

