/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkFormatProperties;

public class VkFormatProperties2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FORMATPROPERTIES;

    VkFormatProperties2KHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkFormatProperties2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkFormatProperties2KHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkFormatProperties2KHR.nsType(this.address());
    }

    public long pNext() {
        return VkFormatProperties2KHR.npNext(this.address());
    }

    public VkFormatProperties formatProperties() {
        return VkFormatProperties2KHR.nformatProperties(this.address());
    }

    public static VkFormatProperties2KHR malloc() {
        return VkFormatProperties2KHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkFormatProperties2KHR calloc() {
        return VkFormatProperties2KHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkFormatProperties2KHR create() {
        return new VkFormatProperties2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkFormatProperties2KHR create(long address) {
        return address == 0L ? null : new VkFormatProperties2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkFormatProperties2KHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFormatProperties2KHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkFormatProperties2KHR mallocStack() {
        return VkFormatProperties2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkFormatProperties2KHR callocStack() {
        return VkFormatProperties2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkFormatProperties2KHR mallocStack(MemoryStack stack) {
        return VkFormatProperties2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFormatProperties2KHR callocStack(MemoryStack stack) {
        return VkFormatProperties2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFormatProperties2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFormatProperties2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkFormatProperties nformatProperties(long struct) {
        return VkFormatProperties.create(struct + (long)FORMATPROPERTIES);
    }

    static {
        Struct.Layout layout = VkFormatProperties2KHR.__struct(VkFormatProperties2KHR.__member(4), VkFormatProperties2KHR.__member(POINTER_SIZE), VkFormatProperties2KHR.__member(VkFormatProperties.SIZEOF, VkFormatProperties.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FORMATPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkFormatProperties2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkFormatProperties2KHR newInstance(long address) {
            return new VkFormatProperties2KHR(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkFormatProperties2KHR.nsType(this.address());
        }

        public long pNext() {
            return VkFormatProperties2KHR.npNext(this.address());
        }

        public VkFormatProperties formatProperties() {
            return VkFormatProperties2KHR.nformatProperties(this.address());
        }
    }
}

