/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageCopy
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSET;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSET;
    public static final int EXTENT;

    VkImageCopy(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageCopy(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageCopy.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageCopy.nsrcSubresource(this.address());
    }

    public VkOffset3D srcOffset() {
        return VkImageCopy.nsrcOffset(this.address());
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageCopy.ndstSubresource(this.address());
    }

    public VkOffset3D dstOffset() {
        return VkImageCopy.ndstOffset(this.address());
    }

    public VkExtent3D extent() {
        return VkImageCopy.nextent(this.address());
    }

    public VkImageCopy srcSubresource(VkImageSubresourceLayers value) {
        VkImageCopy.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy srcOffset(VkOffset3D value) {
        VkImageCopy.nsrcOffset(this.address(), value);
        return this;
    }

    public VkImageCopy dstSubresource(VkImageSubresourceLayers value) {
        VkImageCopy.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy dstOffset(VkOffset3D value) {
        VkImageCopy.ndstOffset(this.address(), value);
        return this;
    }

    public VkImageCopy extent(VkExtent3D value) {
        VkImageCopy.nextent(this.address(), value);
        return this;
    }

    public VkImageCopy set(VkImageSubresourceLayers srcSubresource, VkOffset3D srcOffset, VkImageSubresourceLayers dstSubresource, VkOffset3D dstOffset, VkExtent3D extent) {
        this.srcSubresource(srcSubresource);
        this.srcOffset(srcOffset);
        this.dstSubresource(dstSubresource);
        this.dstOffset(dstOffset);
        this.extent(extent);
        return this;
    }

    public VkImageCopy set(VkImageCopy src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageCopy malloc() {
        return VkImageCopy.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageCopy calloc() {
        return VkImageCopy.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageCopy create() {
        return new VkImageCopy(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageCopy create(long address) {
        return address == 0L ? null : new VkImageCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageCopy.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageCopy.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageCopy mallocStack() {
        return VkImageCopy.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageCopy callocStack() {
        return VkImageCopy.callocStack(MemoryStack.stackGet());
    }

    public static VkImageCopy mallocStack(MemoryStack stack) {
        return VkImageCopy.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageCopy callocStack(MemoryStack stack) {
        return VkImageCopy.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageCopy.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageCopy.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageCopy.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageCopy.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D nsrcOffset(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSET);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D ndstOffset(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCOFFSET, VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageCopy.__struct(VkImageCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageCopy.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBRESOURCE = layout.offsetof(0);
        SRCOFFSET = layout.offsetof(1);
        DSTSUBRESOURCE = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        EXTENT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageCopy, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageCopy newInstance(long address) {
            return new VkImageCopy(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageCopy.nsrcSubresource(this.address());
        }

        public VkOffset3D srcOffset() {
            return VkImageCopy.nsrcOffset(this.address());
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageCopy.ndstSubresource(this.address());
        }

        public VkOffset3D dstOffset() {
            return VkImageCopy.ndstOffset(this.address());
        }

        public VkExtent3D extent() {
            return VkImageCopy.nextent(this.address());
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageCopy.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcOffset(VkOffset3D value) {
            VkImageCopy.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageCopy.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstOffset(VkOffset3D value) {
            VkImageCopy.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCopy.nextent(this.address(), value);
            return this;
        }
    }
}

