/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkImageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int IMAGETYPE;
    public static final int FORMAT;
    public static final int EXTENT;
    public static final int MIPLEVELS;
    public static final int ARRAYLAYERS;
    public static final int SAMPLES;
    public static final int TILING;
    public static final int USAGE;
    public static final int SHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;
    public static final int INITIALLAYOUT;

    VkImageCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkImageCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkImageCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkImageCreateInfo.nflags(this.address());
    }

    public int imageType() {
        return VkImageCreateInfo.nimageType(this.address());
    }

    public int format() {
        return VkImageCreateInfo.nformat(this.address());
    }

    public VkExtent3D extent() {
        return VkImageCreateInfo.nextent(this.address());
    }

    public int mipLevels() {
        return VkImageCreateInfo.nmipLevels(this.address());
    }

    public int arrayLayers() {
        return VkImageCreateInfo.narrayLayers(this.address());
    }

    public int samples() {
        return VkImageCreateInfo.nsamples(this.address());
    }

    public int tiling() {
        return VkImageCreateInfo.ntiling(this.address());
    }

    public int usage() {
        return VkImageCreateInfo.nusage(this.address());
    }

    public int sharingMode() {
        return VkImageCreateInfo.nsharingMode(this.address());
    }

    public int queueFamilyIndexCount() {
        return VkImageCreateInfo.nqueueFamilyIndexCount(this.address());
    }

    public IntBuffer pQueueFamilyIndices() {
        return VkImageCreateInfo.npQueueFamilyIndices(this.address());
    }

    public int initialLayout() {
        return VkImageCreateInfo.ninitialLayout(this.address());
    }

    public VkImageCreateInfo sType(int value) {
        VkImageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageCreateInfo pNext(long value) {
        VkImageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageCreateInfo flags(int value) {
        VkImageCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkImageCreateInfo imageType(int value) {
        VkImageCreateInfo.nimageType(this.address(), value);
        return this;
    }

    public VkImageCreateInfo format(int value) {
        VkImageCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkImageCreateInfo extent(VkExtent3D value) {
        VkImageCreateInfo.nextent(this.address(), value);
        return this;
    }

    public VkImageCreateInfo mipLevels(int value) {
        VkImageCreateInfo.nmipLevels(this.address(), value);
        return this;
    }

    public VkImageCreateInfo arrayLayers(int value) {
        VkImageCreateInfo.narrayLayers(this.address(), value);
        return this;
    }

    public VkImageCreateInfo samples(int value) {
        VkImageCreateInfo.nsamples(this.address(), value);
        return this;
    }

    public VkImageCreateInfo tiling(int value) {
        VkImageCreateInfo.ntiling(this.address(), value);
        return this;
    }

    public VkImageCreateInfo usage(int value) {
        VkImageCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkImageCreateInfo sharingMode(int value) {
        VkImageCreateInfo.nsharingMode(this.address(), value);
        return this;
    }

    public VkImageCreateInfo pQueueFamilyIndices(IntBuffer value) {
        VkImageCreateInfo.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkImageCreateInfo initialLayout(int value) {
        VkImageCreateInfo.ninitialLayout(this.address(), value);
        return this;
    }

    public VkImageCreateInfo set(int sType, long pNext, int flags, int imageType, int format, VkExtent3D extent, int mipLevels, int arrayLayers, int samples, int tiling, int usage, int sharingMode, IntBuffer pQueueFamilyIndices, int initialLayout) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.imageType(imageType);
        this.format(format);
        this.extent(extent);
        this.mipLevels(mipLevels);
        this.arrayLayers(arrayLayers);
        this.samples(samples);
        this.tiling(tiling);
        this.usage(usage);
        this.sharingMode(sharingMode);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        this.initialLayout(initialLayout);
        return this;
    }

    public VkImageCreateInfo set(VkImageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageCreateInfo malloc() {
        return VkImageCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageCreateInfo calloc() {
        return VkImageCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageCreateInfo create() {
        return new VkImageCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageCreateInfo create(long address) {
        return address == 0L ? null : new VkImageCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageCreateInfo mallocStack() {
        return VkImageCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageCreateInfo callocStack() {
        return VkImageCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkImageCreateInfo mallocStack(MemoryStack stack) {
        return VkImageCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageCreateInfo callocStack(MemoryStack stack) {
        return VkImageCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nimageType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGETYPE);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static int nmipLevels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIPLEVELS);
    }

    public static int narrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ARRAYLAYERS);
    }

    public static int nsamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLES);
    }

    public static int ntiling(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TILING);
    }

    public static int nusage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USAGE);
    }

    public static int nsharingMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES), VkImageCreateInfo.nqueueFamilyIndexCount(struct));
    }

    public static int ninitialLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INITIALLAYOUT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nimageType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGETYPE, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    public static void nmipLevels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIPLEVELS, value);
    }

    public static void narrayLayers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ARRAYLAYERS, value);
    }

    public static void nsamples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLES, value);
    }

    public static void ntiling(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TILING, value);
    }

    public static void nusage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USAGE, value);
    }

    public static void nsharingMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEFAMILYINDICES, MemoryUtil.memAddressSafe(value));
        VkImageCreateInfo.nqueueFamilyIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ninitialLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INITIALLAYOUT, value);
    }

    public static void validate(long struct) {
        if (VkImageCreateInfo.nqueueFamilyIndexCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkImageCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkImageCreateInfo.__struct(VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(POINTER_SIZE), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(4), VkImageCreateInfo.__member(POINTER_SIZE), VkImageCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        IMAGETYPE = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        EXTENT = layout.offsetof(5);
        MIPLEVELS = layout.offsetof(6);
        ARRAYLAYERS = layout.offsetof(7);
        SAMPLES = layout.offsetof(8);
        TILING = layout.offsetof(9);
        USAGE = layout.offsetof(10);
        SHARINGMODE = layout.offsetof(11);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(12);
        PQUEUEFAMILYINDICES = layout.offsetof(13);
        INITIALLAYOUT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<VkImageCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageCreateInfo newInstance(long address) {
            return new VkImageCreateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkImageCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkImageCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkImageCreateInfo.nflags(this.address());
        }

        public int imageType() {
            return VkImageCreateInfo.nimageType(this.address());
        }

        public int format() {
            return VkImageCreateInfo.nformat(this.address());
        }

        public VkExtent3D extent() {
            return VkImageCreateInfo.nextent(this.address());
        }

        public int mipLevels() {
            return VkImageCreateInfo.nmipLevels(this.address());
        }

        public int arrayLayers() {
            return VkImageCreateInfo.narrayLayers(this.address());
        }

        public int samples() {
            return VkImageCreateInfo.nsamples(this.address());
        }

        public int tiling() {
            return VkImageCreateInfo.ntiling(this.address());
        }

        public int usage() {
            return VkImageCreateInfo.nusage(this.address());
        }

        public int sharingMode() {
            return VkImageCreateInfo.nsharingMode(this.address());
        }

        public int queueFamilyIndexCount() {
            return VkImageCreateInfo.nqueueFamilyIndexCount(this.address());
        }

        public IntBuffer pQueueFamilyIndices() {
            return VkImageCreateInfo.npQueueFamilyIndices(this.address());
        }

        public int initialLayout() {
            return VkImageCreateInfo.ninitialLayout(this.address());
        }

        public Buffer sType(int value) {
            VkImageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkImageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkImageCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer imageType(int value) {
            VkImageCreateInfo.nimageType(this.address(), value);
            return this;
        }

        public Buffer format(int value) {
            VkImageCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCreateInfo.nextent(this.address(), value);
            return this;
        }

        public Buffer mipLevels(int value) {
            VkImageCreateInfo.nmipLevels(this.address(), value);
            return this;
        }

        public Buffer arrayLayers(int value) {
            VkImageCreateInfo.narrayLayers(this.address(), value);
            return this;
        }

        public Buffer samples(int value) {
            VkImageCreateInfo.nsamples(this.address(), value);
            return this;
        }

        public Buffer tiling(int value) {
            VkImageCreateInfo.ntiling(this.address(), value);
            return this;
        }

        public Buffer usage(int value) {
            VkImageCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer sharingMode(int value) {
            VkImageCreateInfo.nsharingMode(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(IntBuffer value) {
            VkImageCreateInfo.npQueueFamilyIndices(this.address(), value);
            return this;
        }

        public Buffer initialLayout(int value) {
            VkImageCreateInfo.ninitialLayout(this.address(), value);
            return this;
        }
    }
}

