/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageSubresourceRange;

public class VkImageMemoryBarrier
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int OLDLAYOUT;
    public static final int NEWLAYOUT;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int IMAGE;
    public static final int SUBRESOURCERANGE;

    VkImageMemoryBarrier(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageMemoryBarrier(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageMemoryBarrier.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkImageMemoryBarrier.nsType(this.address());
    }

    public long pNext() {
        return VkImageMemoryBarrier.npNext(this.address());
    }

    public int srcAccessMask() {
        return VkImageMemoryBarrier.nsrcAccessMask(this.address());
    }

    public int dstAccessMask() {
        return VkImageMemoryBarrier.ndstAccessMask(this.address());
    }

    public int oldLayout() {
        return VkImageMemoryBarrier.noldLayout(this.address());
    }

    public int newLayout() {
        return VkImageMemoryBarrier.nnewLayout(this.address());
    }

    public int srcQueueFamilyIndex() {
        return VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address());
    }

    public int dstQueueFamilyIndex() {
        return VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address());
    }

    public long image() {
        return VkImageMemoryBarrier.nimage(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkImageMemoryBarrier.nsubresourceRange(this.address());
    }

    public VkImageMemoryBarrier sType(int value) {
        VkImageMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier pNext(long value) {
        VkImageMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier srcAccessMask(int value) {
        VkImageMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier dstAccessMask(int value) {
        VkImageMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier oldLayout(int value) {
        VkImageMemoryBarrier.noldLayout(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier newLayout(int value) {
        VkImageMemoryBarrier.nnewLayout(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier srcQueueFamilyIndex(int value) {
        VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier dstQueueFamilyIndex(int value) {
        VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier image(long value) {
        VkImageMemoryBarrier.nimage(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier subresourceRange(VkImageSubresourceRange value) {
        VkImageMemoryBarrier.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask, int oldLayout, int newLayout, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long image, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.oldLayout(oldLayout);
        this.newLayout(newLayout);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.image(image);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkImageMemoryBarrier set(VkImageMemoryBarrier src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageMemoryBarrier malloc() {
        return VkImageMemoryBarrier.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageMemoryBarrier calloc() {
        return VkImageMemoryBarrier.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageMemoryBarrier create() {
        return new VkImageMemoryBarrier(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageMemoryBarrier create(long address) {
        return address == 0L ? null : new VkImageMemoryBarrier(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageMemoryBarrier.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageMemoryBarrier.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageMemoryBarrier mallocStack() {
        return VkImageMemoryBarrier.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryBarrier callocStack() {
        return VkImageMemoryBarrier.callocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryBarrier mallocStack(MemoryStack stack) {
        return VkImageMemoryBarrier.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageMemoryBarrier callocStack(MemoryStack stack) {
        return VkImageMemoryBarrier.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageMemoryBarrier.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageMemoryBarrier.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryBarrier.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryBarrier.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsrcAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTACCESSMASK);
    }

    public static int noldLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLDLAYOUT);
    }

    public static int nnewLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NEWLAYOUT);
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCQUEUEFAMILYINDEX);
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTQUEUEFAMILYINDEX);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTACCESSMASK, value);
    }

    public static void noldLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OLDLAYOUT, value);
    }

    public static void nnewLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NEWLAYOUT, value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCQUEUEFAMILYINDEX, value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTQUEUEFAMILYINDEX, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCERANGE, VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageMemoryBarrier.__struct(VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(POINTER_SIZE), VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(4), VkImageMemoryBarrier.__member(8), VkImageMemoryBarrier.__member(VkImageSubresourceRange.SIZEOF, VkImageSubresourceRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
        OLDLAYOUT = layout.offsetof(4);
        NEWLAYOUT = layout.offsetof(5);
        SRCQUEUEFAMILYINDEX = layout.offsetof(6);
        DSTQUEUEFAMILYINDEX = layout.offsetof(7);
        IMAGE = layout.offsetof(8);
        SUBRESOURCERANGE = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkImageMemoryBarrier, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageMemoryBarrier newInstance(long address) {
            return new VkImageMemoryBarrier(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkImageMemoryBarrier.nsType(this.address());
        }

        public long pNext() {
            return VkImageMemoryBarrier.npNext(this.address());
        }

        public int srcAccessMask() {
            return VkImageMemoryBarrier.nsrcAccessMask(this.address());
        }

        public int dstAccessMask() {
            return VkImageMemoryBarrier.ndstAccessMask(this.address());
        }

        public int oldLayout() {
            return VkImageMemoryBarrier.noldLayout(this.address());
        }

        public int newLayout() {
            return VkImageMemoryBarrier.nnewLayout(this.address());
        }

        public int srcQueueFamilyIndex() {
            return VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address());
        }

        public int dstQueueFamilyIndex() {
            return VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address());
        }

        public long image() {
            return VkImageMemoryBarrier.nimage(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkImageMemoryBarrier.nsubresourceRange(this.address());
        }

        public Buffer sType(int value) {
            VkImageMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkImageMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(int value) {
            VkImageMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(int value) {
            VkImageMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer oldLayout(int value) {
            VkImageMemoryBarrier.noldLayout(this.address(), value);
            return this;
        }

        public Buffer newLayout(int value) {
            VkImageMemoryBarrier.nnewLayout(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(int value) {
            VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(int value) {
            VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer image(long value) {
            VkImageMemoryBarrier.nimage(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkImageMemoryBarrier.nsubresourceRange(this.address(), value);
            return this;
        }
    }
}

