/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresourceRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int BASEMIPLEVEL;
    public static final int LEVELCOUNT;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    VkImageSubresourceRange(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageSubresourceRange(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageSubresourceRange.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int aspectMask() {
        return VkImageSubresourceRange.naspectMask(this.address());
    }

    public int baseMipLevel() {
        return VkImageSubresourceRange.nbaseMipLevel(this.address());
    }

    public int levelCount() {
        return VkImageSubresourceRange.nlevelCount(this.address());
    }

    public int baseArrayLayer() {
        return VkImageSubresourceRange.nbaseArrayLayer(this.address());
    }

    public int layerCount() {
        return VkImageSubresourceRange.nlayerCount(this.address());
    }

    public VkImageSubresourceRange aspectMask(int value) {
        VkImageSubresourceRange.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange baseMipLevel(int value) {
        VkImageSubresourceRange.nbaseMipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange levelCount(int value) {
        VkImageSubresourceRange.nlevelCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange baseArrayLayer(int value) {
        VkImageSubresourceRange.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange layerCount(int value) {
        VkImageSubresourceRange.nlayerCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange set(int aspectMask, int baseMipLevel, int levelCount, int baseArrayLayer, int layerCount) {
        this.aspectMask(aspectMask);
        this.baseMipLevel(baseMipLevel);
        this.levelCount(levelCount);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkImageSubresourceRange set(VkImageSubresourceRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageSubresourceRange malloc() {
        return VkImageSubresourceRange.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageSubresourceRange calloc() {
        return VkImageSubresourceRange.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageSubresourceRange create() {
        return new VkImageSubresourceRange(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageSubresourceRange create(long address) {
        return address == 0L ? null : new VkImageSubresourceRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageSubresourceRange.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageSubresourceRange.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageSubresourceRange mallocStack() {
        return VkImageSubresourceRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresourceRange callocStack() {
        return VkImageSubresourceRange.callocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresourceRange mallocStack(MemoryStack stack) {
        return VkImageSubresourceRange.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageSubresourceRange callocStack(MemoryStack stack) {
        return VkImageSubresourceRange.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageSubresourceRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageSubresourceRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceRange.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceRange.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static int nbaseMipLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEMIPLEVEL);
    }

    public static int nlevelCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEVELCOUNT);
    }

    public static int nbaseArrayLayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERCOUNT);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTMASK, value);
    }

    public static void nbaseMipLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEMIPLEVEL, value);
    }

    public static void nlevelCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LEVELCOUNT, value);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkImageSubresourceRange.__struct(VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        BASEMIPLEVEL = layout.offsetof(1);
        LEVELCOUNT = layout.offsetof(2);
        BASEARRAYLAYER = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresourceRange, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageSubresourceRange newInstance(long address) {
            return new VkImageSubresourceRange(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int aspectMask() {
            return VkImageSubresourceRange.naspectMask(this.address());
        }

        public int baseMipLevel() {
            return VkImageSubresourceRange.nbaseMipLevel(this.address());
        }

        public int levelCount() {
            return VkImageSubresourceRange.nlevelCount(this.address());
        }

        public int baseArrayLayer() {
            return VkImageSubresourceRange.nbaseArrayLayer(this.address());
        }

        public int layerCount() {
            return VkImageSubresourceRange.nlayerCount(this.address());
        }

        public Buffer aspectMask(int value) {
            VkImageSubresourceRange.naspectMask(this.address(), value);
            return this;
        }

        public Buffer baseMipLevel(int value) {
            VkImageSubresourceRange.nbaseMipLevel(this.address(), value);
            return this;
        }

        public Buffer levelCount(int value) {
            VkImageSubresourceRange.nlevelCount(this.address(), value);
            return this;
        }

        public Buffer baseArrayLayer(int value) {
            VkImageSubresourceRange.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(int value) {
            VkImageSubresourceRange.nlayerCount(this.address(), value);
            return this;
        }
    }
}

