/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryFdInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int FD;

    VkImportMemoryFdInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImportMemoryFdInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImportMemoryFdInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkImportMemoryFdInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkImportMemoryFdInfoKHX.npNext(this.address());
    }

    public int handleType() {
        return VkImportMemoryFdInfoKHX.nhandleType(this.address());
    }

    public int fd() {
        return VkImportMemoryFdInfoKHX.nfd(this.address());
    }

    public VkImportMemoryFdInfoKHX sType(int value) {
        VkImportMemoryFdInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHX pNext(long value) {
        VkImportMemoryFdInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHX handleType(int value) {
        VkImportMemoryFdInfoKHX.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHX fd(int value) {
        VkImportMemoryFdInfoKHX.nfd(this.address(), value);
        return this;
    }

    public VkImportMemoryFdInfoKHX set(int sType, long pNext, int handleType, int fd) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.fd(fd);
        return this;
    }

    public VkImportMemoryFdInfoKHX set(VkImportMemoryFdInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMemoryFdInfoKHX malloc() {
        return VkImportMemoryFdInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImportMemoryFdInfoKHX calloc() {
        return VkImportMemoryFdInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImportMemoryFdInfoKHX create() {
        return new VkImportMemoryFdInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImportMemoryFdInfoKHX create(long address) {
        return address == 0L ? null : new VkImportMemoryFdInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImportMemoryFdInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImportMemoryFdInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImportMemoryFdInfoKHX mallocStack() {
        return VkImportMemoryFdInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryFdInfoKHX callocStack() {
        return VkImportMemoryFdInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryFdInfoKHX mallocStack(MemoryStack stack) {
        return VkImportMemoryFdInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportMemoryFdInfoKHX callocStack(MemoryStack stack) {
        return VkImportMemoryFdInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryFdInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImportMemoryFdInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryFdInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryFdInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static int nfd(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FD);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    public static void nfd(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FD, value);
    }

    static {
        Struct.Layout layout = VkImportMemoryFdInfoKHX.__struct(VkImportMemoryFdInfoKHX.__member(4), VkImportMemoryFdInfoKHX.__member(POINTER_SIZE), VkImportMemoryFdInfoKHX.__member(4), VkImportMemoryFdInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        FD = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryFdInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImportMemoryFdInfoKHX newInstance(long address) {
            return new VkImportMemoryFdInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkImportMemoryFdInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkImportMemoryFdInfoKHX.npNext(this.address());
        }

        public int handleType() {
            return VkImportMemoryFdInfoKHX.nhandleType(this.address());
        }

        public int fd() {
            return VkImportMemoryFdInfoKHX.nfd(this.address());
        }

        public Buffer sType(int value) {
            VkImportMemoryFdInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkImportMemoryFdInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(int value) {
            VkImportMemoryFdInfoKHX.nhandleType(this.address(), value);
            return this;
        }

        public Buffer fd(int value) {
            VkImportMemoryFdInfoKHX.nfd(this.address(), value);
            return this;
        }
    }
}

