/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryWin32HandleInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int HANDLE;

    VkImportMemoryWin32HandleInfoNV(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImportMemoryWin32HandleInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImportMemoryWin32HandleInfoNV.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
    }

    public long pNext() {
        return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
    }

    public int handleType() {
        return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
    }

    public long handle() {
        return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
    }

    public VkImportMemoryWin32HandleInfoNV sType(int value) {
        VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV pNext(long value) {
        VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handleType(int value) {
        VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handle(long value) {
        VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(int sType, long pNext, int handleType, long handle) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.handle(handle);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(VkImportMemoryWin32HandleInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMemoryWin32HandleInfoNV malloc() {
        return VkImportMemoryWin32HandleInfoNV.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV calloc() {
        return VkImportMemoryWin32HandleInfoNV.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV create() {
        return new VkImportMemoryWin32HandleInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV create(long address) {
        return address == 0L ? null : new VkImportMemoryWin32HandleInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImportMemoryWin32HandleInfoNV mallocStack() {
        return VkImportMemoryWin32HandleInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryWin32HandleInfoNV callocStack() {
        return VkImportMemoryWin32HandleInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryWin32HandleInfoNV mallocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV callocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkImportMemoryWin32HandleInfoNV.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkImportMemoryWin32HandleInfoNV.__struct(VkImportMemoryWin32HandleInfoNV.__member(4), VkImportMemoryWin32HandleInfoNV.__member(POINTER_SIZE), VkImportMemoryWin32HandleInfoNV.__member(4), VkImportMemoryWin32HandleInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryWin32HandleInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImportMemoryWin32HandleInfoNV newInstance(long address) {
            return new VkImportMemoryWin32HandleInfoNV(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
        }

        public long pNext() {
            return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
        }

        public int handleType() {
            return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
        }

        public long handle() {
            return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
        }

        public Buffer sType(int value) {
            VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(int value) {
            VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(long value) {
            VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
            return this;
        }
    }
}

