/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutTokenNVX;

public class VkIndirectCommandsLayoutCreateInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINEBINDPOINT;
    public static final int FLAGS;
    public static final int TOKENCOUNT;
    public static final int PTOKENS;

    VkIndirectCommandsLayoutCreateInfoNVX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkIndirectCommandsLayoutCreateInfoNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkIndirectCommandsLayoutCreateInfoNVX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address());
    }

    public long pNext() {
        return VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address());
    }

    public int pipelineBindPoint() {
        return VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address());
    }

    public int flags() {
        return VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address());
    }

    public int tokenCount() {
        return VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(this.address());
    }

    public VkIndirectCommandsLayoutTokenNVX.Buffer pTokens() {
        return VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address());
    }

    public VkIndirectCommandsLayoutCreateInfoNVX sType(int value) {
        VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX pNext(long value) {
        VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX pipelineBindPoint(int value) {
        VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX flags(int value) {
        VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX pTokens(VkIndirectCommandsLayoutTokenNVX.Buffer value) {
        VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX set(int sType, long pNext, int pipelineBindPoint, int flags, VkIndirectCommandsLayoutTokenNVX.Buffer pTokens) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipelineBindPoint(pipelineBindPoint);
        this.flags(flags);
        this.pTokens(pTokens);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNVX set(VkIndirectCommandsLayoutCreateInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX malloc() {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX calloc() {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX create() {
        return new VkIndirectCommandsLayoutCreateInfoNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX create(long address) {
        return address == 0L ? null : new VkIndirectCommandsLayoutCreateInfoNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX mallocStack() {
        return VkIndirectCommandsLayoutCreateInfoNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX callocStack() {
        return VkIndirectCommandsLayoutCreateInfoNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX mallocStack(MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkIndirectCommandsLayoutCreateInfoNVX callocStack(MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkIndirectCommandsLayoutCreateInfoNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkIndirectCommandsLayoutCreateInfoNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int npipelineBindPoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINEBINDPOINT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ntokenCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOKENCOUNT);
    }

    public static VkIndirectCommandsLayoutTokenNVX.Buffer npTokens(long struct) {
        return VkIndirectCommandsLayoutTokenNVX.create(MemoryUtil.memGetAddress(struct + (long)PTOKENS), VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ntokenCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOKENCOUNT, value);
    }

    public static void npTokens(long struct, VkIndirectCommandsLayoutTokenNVX.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PTOKENS, value.address());
        VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PTOKENS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkIndirectCommandsLayoutCreateInfoNVX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutCreateInfoNVX.__struct(VkIndirectCommandsLayoutCreateInfoNVX.__member(4), VkIndirectCommandsLayoutCreateInfoNVX.__member(POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoNVX.__member(4), VkIndirectCommandsLayoutCreateInfoNVX.__member(4), VkIndirectCommandsLayoutCreateInfoNVX.__member(4), VkIndirectCommandsLayoutCreateInfoNVX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINEBINDPOINT = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        TOKENCOUNT = layout.offsetof(4);
        PTOKENS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutCreateInfoNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkIndirectCommandsLayoutCreateInfoNVX newInstance(long address) {
            return new VkIndirectCommandsLayoutCreateInfoNVX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address());
        }

        public long pNext() {
            return VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address());
        }

        public int pipelineBindPoint() {
            return VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address());
        }

        public int flags() {
            return VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address());
        }

        public int tokenCount() {
            return VkIndirectCommandsLayoutCreateInfoNVX.ntokenCount(this.address());
        }

        public VkIndirectCommandsLayoutTokenNVX.Buffer pTokens() {
            return VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address());
        }

        public Buffer sType(int value) {
            VkIndirectCommandsLayoutCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkIndirectCommandsLayoutCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(int value) {
            VkIndirectCommandsLayoutCreateInfoNVX.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkIndirectCommandsLayoutCreateInfoNVX.nflags(this.address(), value);
            return this;
        }

        public Buffer pTokens(VkIndirectCommandsLayoutTokenNVX.Buffer value) {
            VkIndirectCommandsLayoutCreateInfoNVX.npTokens(this.address(), value);
            return this;
        }
    }
}

