/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkIndirectCommandsLayoutTokenNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOKENTYPE;
    public static final int BINDINGUNIT;
    public static final int DYNAMICCOUNT;
    public static final int DIVISOR;

    VkIndirectCommandsLayoutTokenNVX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkIndirectCommandsLayoutTokenNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkIndirectCommandsLayoutTokenNVX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int tokenType() {
        return VkIndirectCommandsLayoutTokenNVX.ntokenType(this.address());
    }

    public int bindingUnit() {
        return VkIndirectCommandsLayoutTokenNVX.nbindingUnit(this.address());
    }

    public int dynamicCount() {
        return VkIndirectCommandsLayoutTokenNVX.ndynamicCount(this.address());
    }

    public int divisor() {
        return VkIndirectCommandsLayoutTokenNVX.ndivisor(this.address());
    }

    public VkIndirectCommandsLayoutTokenNVX tokenType(int value) {
        VkIndirectCommandsLayoutTokenNVX.ntokenType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNVX bindingUnit(int value) {
        VkIndirectCommandsLayoutTokenNVX.nbindingUnit(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNVX dynamicCount(int value) {
        VkIndirectCommandsLayoutTokenNVX.ndynamicCount(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNVX divisor(int value) {
        VkIndirectCommandsLayoutTokenNVX.ndivisor(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNVX set(int tokenType, int bindingUnit, int dynamicCount, int divisor) {
        this.tokenType(tokenType);
        this.bindingUnit(bindingUnit);
        this.dynamicCount(dynamicCount);
        this.divisor(divisor);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNVX set(VkIndirectCommandsLayoutTokenNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutTokenNVX malloc() {
        return VkIndirectCommandsLayoutTokenNVX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkIndirectCommandsLayoutTokenNVX calloc() {
        return VkIndirectCommandsLayoutTokenNVX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkIndirectCommandsLayoutTokenNVX create() {
        return new VkIndirectCommandsLayoutTokenNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkIndirectCommandsLayoutTokenNVX create(long address) {
        return address == 0L ? null : new VkIndirectCommandsLayoutTokenNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkIndirectCommandsLayoutTokenNVX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkIndirectCommandsLayoutTokenNVX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkIndirectCommandsLayoutTokenNVX mallocStack() {
        return VkIndirectCommandsLayoutTokenNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsLayoutTokenNVX callocStack() {
        return VkIndirectCommandsLayoutTokenNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsLayoutTokenNVX mallocStack(MemoryStack stack) {
        return VkIndirectCommandsLayoutTokenNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkIndirectCommandsLayoutTokenNVX callocStack(MemoryStack stack) {
        return VkIndirectCommandsLayoutTokenNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkIndirectCommandsLayoutTokenNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkIndirectCommandsLayoutTokenNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkIndirectCommandsLayoutTokenNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkIndirectCommandsLayoutTokenNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntokenType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOKENTYPE);
    }

    public static int nbindingUnit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDINGUNIT);
    }

    public static int ndynamicCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DYNAMICCOUNT);
    }

    public static int ndivisor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DIVISOR);
    }

    public static void ntokenType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOKENTYPE, value);
    }

    public static void nbindingUnit(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDINGUNIT, value);
    }

    public static void ndynamicCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DYNAMICCOUNT, value);
    }

    public static void ndivisor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DIVISOR, value);
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutTokenNVX.__struct(VkIndirectCommandsLayoutTokenNVX.__member(4), VkIndirectCommandsLayoutTokenNVX.__member(4), VkIndirectCommandsLayoutTokenNVX.__member(4), VkIndirectCommandsLayoutTokenNVX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOKENTYPE = layout.offsetof(0);
        BINDINGUNIT = layout.offsetof(1);
        DYNAMICCOUNT = layout.offsetof(2);
        DIVISOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutTokenNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkIndirectCommandsLayoutTokenNVX newInstance(long address) {
            return new VkIndirectCommandsLayoutTokenNVX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int tokenType() {
            return VkIndirectCommandsLayoutTokenNVX.ntokenType(this.address());
        }

        public int bindingUnit() {
            return VkIndirectCommandsLayoutTokenNVX.nbindingUnit(this.address());
        }

        public int dynamicCount() {
            return VkIndirectCommandsLayoutTokenNVX.ndynamicCount(this.address());
        }

        public int divisor() {
            return VkIndirectCommandsLayoutTokenNVX.ndivisor(this.address());
        }

        public Buffer tokenType(int value) {
            VkIndirectCommandsLayoutTokenNVX.ntokenType(this.address(), value);
            return this;
        }

        public Buffer bindingUnit(int value) {
            VkIndirectCommandsLayoutTokenNVX.nbindingUnit(this.address(), value);
            return this;
        }

        public Buffer dynamicCount(int value) {
            VkIndirectCommandsLayoutTokenNVX.ndynamicCount(this.address(), value);
            return this;
        }

        public Buffer divisor(int value) {
            VkIndirectCommandsLayoutTokenNVX.ndivisor(this.address(), value);
            return this;
        }
    }
}

