/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleInstance;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkInstanceCreateInfo;

public class VkInstance
extends DispatchableHandleInstance {
    public VkInstance(long handle, VkInstanceCreateInfo ci) {
        super(handle, VkInstance.getInstanceCapabilities(handle, ci));
    }

    private static VKCapabilitiesInstance getInstanceCapabilities(long handle, VkInstanceCreateInfo ci) {
        VkApplicationInfo appInfo = ci.pApplicationInfo();
        int apiVersion = appInfo != null ? appInfo.apiVersion() : VK10.VK_MAKE_VERSION(1, 0, 0);
        long GetInstanceProcAddr = VK.getFunctionProvider().getFunctionAddress("vkGetInstanceProcAddr");
        if (GetInstanceProcAddr == 0L) {
            throw new IllegalStateException("A core Vulkan function is missing. Make sure that Vulkan is available.");
        }
        return new VKCapabilitiesInstance(functionName -> {
            long address = JNI.callPPP(GetInstanceProcAddr, handle, MemoryUtil.memAddress(functionName));
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for VK instance function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }, apiVersion, VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()));
    }
}

