/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMappedMemoryRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int OFFSET;
    public static final int SIZE;

    VkMappedMemoryRange(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMappedMemoryRange(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMappedMemoryRange.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkMappedMemoryRange.nsType(this.address());
    }

    public long pNext() {
        return VkMappedMemoryRange.npNext(this.address());
    }

    public long memory() {
        return VkMappedMemoryRange.nmemory(this.address());
    }

    public long offset() {
        return VkMappedMemoryRange.noffset(this.address());
    }

    public long size() {
        return VkMappedMemoryRange.nsize(this.address());
    }

    public VkMappedMemoryRange sType(int value) {
        VkMappedMemoryRange.nsType(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange pNext(long value) {
        VkMappedMemoryRange.npNext(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange memory(long value) {
        VkMappedMemoryRange.nmemory(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange offset(long value) {
        VkMappedMemoryRange.noffset(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange size(long value) {
        VkMappedMemoryRange.nsize(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange set(int sType, long pNext, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMappedMemoryRange set(VkMappedMemoryRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMappedMemoryRange malloc() {
        return VkMappedMemoryRange.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMappedMemoryRange calloc() {
        return VkMappedMemoryRange.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMappedMemoryRange create() {
        return new VkMappedMemoryRange(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMappedMemoryRange create(long address) {
        return address == 0L ? null : new VkMappedMemoryRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMappedMemoryRange.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMappedMemoryRange.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMappedMemoryRange mallocStack() {
        return VkMappedMemoryRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkMappedMemoryRange callocStack() {
        return VkMappedMemoryRange.callocStack(MemoryStack.stackGet());
    }

    public static VkMappedMemoryRange mallocStack(MemoryStack stack) {
        return VkMappedMemoryRange.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMappedMemoryRange callocStack(MemoryStack stack) {
        return VkMappedMemoryRange.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMappedMemoryRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMappedMemoryRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMappedMemoryRange.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMappedMemoryRange.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkMappedMemoryRange.__struct(VkMappedMemoryRange.__member(4), VkMappedMemoryRange.__member(POINTER_SIZE), VkMappedMemoryRange.__member(8), VkMappedMemoryRange.__member(8), VkMappedMemoryRange.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
        SIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkMappedMemoryRange, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMappedMemoryRange newInstance(long address) {
            return new VkMappedMemoryRange(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkMappedMemoryRange.nsType(this.address());
        }

        public long pNext() {
            return VkMappedMemoryRange.npNext(this.address());
        }

        public long memory() {
            return VkMappedMemoryRange.nmemory(this.address());
        }

        public long offset() {
            return VkMappedMemoryRange.noffset(this.address());
        }

        public long size() {
            return VkMappedMemoryRange.nsize(this.address());
        }

        public Buffer sType(int value) {
            VkMappedMemoryRange.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkMappedMemoryRange.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(long value) {
            VkMappedMemoryRange.nmemory(this.address(), value);
            return this;
        }

        public Buffer offset(long value) {
            VkMappedMemoryRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            VkMappedMemoryRange.nsize(this.address(), value);
            return this;
        }
    }
}

