/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateFlagsInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEVICEMASK;

    VkMemoryAllocateFlagsInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryAllocateFlagsInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryAllocateFlagsInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkMemoryAllocateFlagsInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkMemoryAllocateFlagsInfoKHX.npNext(this.address());
    }

    public int flags() {
        return VkMemoryAllocateFlagsInfoKHX.nflags(this.address());
    }

    public int deviceMask() {
        return VkMemoryAllocateFlagsInfoKHX.ndeviceMask(this.address());
    }

    public VkMemoryAllocateFlagsInfoKHX sType(int value) {
        VkMemoryAllocateFlagsInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHX pNext(long value) {
        VkMemoryAllocateFlagsInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHX flags(int value) {
        VkMemoryAllocateFlagsInfoKHX.nflags(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHX deviceMask(int value) {
        VkMemoryAllocateFlagsInfoKHX.ndeviceMask(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHX set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHX set(VkMemoryAllocateFlagsInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfoKHX malloc() {
        return VkMemoryAllocateFlagsInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHX calloc() {
        return VkMemoryAllocateFlagsInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHX create() {
        return new VkMemoryAllocateFlagsInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHX create(long address) {
        return address == 0L ? null : new VkMemoryAllocateFlagsInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryAllocateFlagsInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryAllocateFlagsInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMemoryAllocateFlagsInfoKHX mallocStack() {
        return VkMemoryAllocateFlagsInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfoKHX callocStack() {
        return VkMemoryAllocateFlagsInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfoKHX mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHX callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateFlagsInfoKHX.__struct(VkMemoryAllocateFlagsInfoKHX.__member(4), VkMemoryAllocateFlagsInfoKHX.__member(POINTER_SIZE), VkMemoryAllocateFlagsInfoKHX.__member(4), VkMemoryAllocateFlagsInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEVICEMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateFlagsInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryAllocateFlagsInfoKHX newInstance(long address) {
            return new VkMemoryAllocateFlagsInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkMemoryAllocateFlagsInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkMemoryAllocateFlagsInfoKHX.npNext(this.address());
        }

        public int flags() {
            return VkMemoryAllocateFlagsInfoKHX.nflags(this.address());
        }

        public int deviceMask() {
            return VkMemoryAllocateFlagsInfoKHX.ndeviceMask(this.address());
        }

        public Buffer sType(int value) {
            VkMemoryAllocateFlagsInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkMemoryAllocateFlagsInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkMemoryAllocateFlagsInfoKHX.nflags(this.address(), value);
            return this;
        }

        public Buffer deviceMask(int value) {
            VkMemoryAllocateFlagsInfoKHX.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

