/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ALLOCATIONSIZE;
    public static final int MEMORYTYPEINDEX;

    VkMemoryAllocateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryAllocateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryAllocateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkMemoryAllocateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkMemoryAllocateInfo.npNext(this.address());
    }

    public long allocationSize() {
        return VkMemoryAllocateInfo.nallocationSize(this.address());
    }

    public int memoryTypeIndex() {
        return VkMemoryAllocateInfo.nmemoryTypeIndex(this.address());
    }

    public VkMemoryAllocateInfo sType(int value) {
        VkMemoryAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo pNext(long value) {
        VkMemoryAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo allocationSize(long value) {
        VkMemoryAllocateInfo.nallocationSize(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo memoryTypeIndex(int value) {
        VkMemoryAllocateInfo.nmemoryTypeIndex(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo set(int sType, long pNext, long allocationSize, int memoryTypeIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.allocationSize(allocationSize);
        this.memoryTypeIndex(memoryTypeIndex);
        return this;
    }

    public VkMemoryAllocateInfo set(VkMemoryAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryAllocateInfo malloc() {
        return VkMemoryAllocateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMemoryAllocateInfo calloc() {
        return VkMemoryAllocateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMemoryAllocateInfo create() {
        return new VkMemoryAllocateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryAllocateInfo create(long address) {
        return address == 0L ? null : new VkMemoryAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryAllocateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryAllocateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMemoryAllocateInfo mallocStack() {
        return VkMemoryAllocateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateInfo callocStack() {
        return VkMemoryAllocateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateInfo mallocStack(MemoryStack stack) {
        return VkMemoryAllocateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateInfo callocStack(MemoryStack stack) {
        return VkMemoryAllocateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nallocationSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ALLOCATIONSIZE);
    }

    public static int nmemoryTypeIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nallocationSize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ALLOCATIONSIZE, value);
    }

    public static void nmemoryTypeIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYTYPEINDEX, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateInfo.__struct(VkMemoryAllocateInfo.__member(4), VkMemoryAllocateInfo.__member(POINTER_SIZE), VkMemoryAllocateInfo.__member(8), VkMemoryAllocateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ALLOCATIONSIZE = layout.offsetof(2);
        MEMORYTYPEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryAllocateInfo newInstance(long address) {
            return new VkMemoryAllocateInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkMemoryAllocateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkMemoryAllocateInfo.npNext(this.address());
        }

        public long allocationSize() {
            return VkMemoryAllocateInfo.nallocationSize(this.address());
        }

        public int memoryTypeIndex() {
            return VkMemoryAllocateInfo.nmemoryTypeIndex(this.address());
        }

        public Buffer sType(int value) {
            VkMemoryAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkMemoryAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer allocationSize(long value) {
            VkMemoryAllocateInfo.nallocationSize(this.address(), value);
            return this;
        }

        public Buffer memoryTypeIndex(int value) {
            VkMemoryAllocateInfo.nmemoryTypeIndex(this.address(), value);
            return this;
        }
    }
}

