/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryBarrier
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;

    VkMemoryBarrier(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryBarrier(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryBarrier.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkMemoryBarrier.nsType(this.address());
    }

    public long pNext() {
        return VkMemoryBarrier.npNext(this.address());
    }

    public int srcAccessMask() {
        return VkMemoryBarrier.nsrcAccessMask(this.address());
    }

    public int dstAccessMask() {
        return VkMemoryBarrier.ndstAccessMask(this.address());
    }

    public VkMemoryBarrier sType(int value) {
        VkMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkMemoryBarrier pNext(long value) {
        VkMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkMemoryBarrier srcAccessMask(int value) {
        VkMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier dstAccessMask(int value) {
        VkMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        return this;
    }

    public VkMemoryBarrier set(VkMemoryBarrier src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryBarrier malloc() {
        return VkMemoryBarrier.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMemoryBarrier calloc() {
        return VkMemoryBarrier.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMemoryBarrier create() {
        return new VkMemoryBarrier(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryBarrier create(long address) {
        return address == 0L ? null : new VkMemoryBarrier(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryBarrier.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryBarrier.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMemoryBarrier mallocStack() {
        return VkMemoryBarrier.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryBarrier callocStack() {
        return VkMemoryBarrier.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryBarrier mallocStack(MemoryStack stack) {
        return VkMemoryBarrier.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryBarrier callocStack(MemoryStack stack) {
        return VkMemoryBarrier.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryBarrier.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryBarrier.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryBarrier.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryBarrier.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsrcAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTACCESSMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTACCESSMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryBarrier.__struct(VkMemoryBarrier.__member(4), VkMemoryBarrier.__member(POINTER_SIZE), VkMemoryBarrier.__member(4), VkMemoryBarrier.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryBarrier, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryBarrier newInstance(long address) {
            return new VkMemoryBarrier(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkMemoryBarrier.nsType(this.address());
        }

        public long pNext() {
            return VkMemoryBarrier.npNext(this.address());
        }

        public int srcAccessMask() {
            return VkMemoryBarrier.nsrcAccessMask(this.address());
        }

        public int dstAccessMask() {
            return VkMemoryBarrier.ndstAccessMask(this.address());
        }

        public Buffer sType(int value) {
            VkMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(int value) {
            VkMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(int value) {
            VkMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }
    }
}

