/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryFdPropertiesKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYTYPEBITS;

    VkMemoryFdPropertiesKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryFdPropertiesKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryFdPropertiesKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkMemoryFdPropertiesKHX.nsType(this.address());
    }

    public long pNext() {
        return VkMemoryFdPropertiesKHX.npNext(this.address());
    }

    public int memoryTypeBits() {
        return VkMemoryFdPropertiesKHX.nmemoryTypeBits(this.address());
    }

    public static VkMemoryFdPropertiesKHX malloc() {
        return VkMemoryFdPropertiesKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMemoryFdPropertiesKHX calloc() {
        return VkMemoryFdPropertiesKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMemoryFdPropertiesKHX create() {
        return new VkMemoryFdPropertiesKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryFdPropertiesKHX create(long address) {
        return address == 0L ? null : new VkMemoryFdPropertiesKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryFdPropertiesKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryFdPropertiesKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMemoryFdPropertiesKHX mallocStack() {
        return VkMemoryFdPropertiesKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryFdPropertiesKHX callocStack() {
        return VkMemoryFdPropertiesKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryFdPropertiesKHX mallocStack(MemoryStack stack) {
        return VkMemoryFdPropertiesKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryFdPropertiesKHX callocStack(MemoryStack stack) {
        return VkMemoryFdPropertiesKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryFdPropertiesKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryFdPropertiesKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryFdPropertiesKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryFdPropertiesKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEBITS);
    }

    static {
        Struct.Layout layout = VkMemoryFdPropertiesKHX.__struct(VkMemoryFdPropertiesKHX.__member(4), VkMemoryFdPropertiesKHX.__member(POINTER_SIZE), VkMemoryFdPropertiesKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryFdPropertiesKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryFdPropertiesKHX newInstance(long address) {
            return new VkMemoryFdPropertiesKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkMemoryFdPropertiesKHX.nsType(this.address());
        }

        public long pNext() {
            return VkMemoryFdPropertiesKHX.npNext(this.address());
        }

        public int memoryTypeBits() {
            return VkMemoryFdPropertiesKHX.nmemoryTypeBits(this.address());
        }
    }
}

