/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHeap
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;

    VkMemoryHeap(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryHeap(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryHeap.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long size() {
        return VkMemoryHeap.nsize(this.address());
    }

    public int flags() {
        return VkMemoryHeap.nflags(this.address());
    }

    public static VkMemoryHeap create(long address) {
        return address == 0L ? null : new VkMemoryHeap(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkMemoryHeap.__struct(VkMemoryHeap.__member(8), VkMemoryHeap.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHeap, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryHeap newInstance(long address) {
            return new VkMemoryHeap(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long size() {
            return VkMemoryHeap.nsize(this.address());
        }

        public int flags() {
            return VkMemoryHeap.nflags(this.address());
        }
    }
}

