/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryType
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROPERTYFLAGS;
    public static final int HEAPINDEX;

    VkMemoryType(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryType(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryType.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int propertyFlags() {
        return VkMemoryType.npropertyFlags(this.address());
    }

    public int heapIndex() {
        return VkMemoryType.nheapIndex(this.address());
    }

    public static VkMemoryType create(long address) {
        return address == 0L ? null : new VkMemoryType(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int npropertyFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROPERTYFLAGS);
    }

    public static int nheapIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAPINDEX);
    }

    static {
        Struct.Layout layout = VkMemoryType.__struct(VkMemoryType.__member(4), VkMemoryType.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROPERTYFLAGS = layout.offsetof(0);
        HEAPINDEX = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryType, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryType newInstance(long address) {
            return new VkMemoryType(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int propertyFlags() {
            return VkMemoryType.npropertyFlags(this.address());
        }

        public int heapIndex() {
            return VkMemoryType.nheapIndex(this.address());
        }
    }
}

