/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceFeatures
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ROBUSTBUFFERACCESS;
    public static final int FULLDRAWINDEXUINT32;
    public static final int IMAGECUBEARRAY;
    public static final int INDEPENDENTBLEND;
    public static final int GEOMETRYSHADER;
    public static final int TESSELLATIONSHADER;
    public static final int SAMPLERATESHADING;
    public static final int DUALSRCBLEND;
    public static final int LOGICOP;
    public static final int MULTIDRAWINDIRECT;
    public static final int DRAWINDIRECTFIRSTINSTANCE;
    public static final int DEPTHCLAMP;
    public static final int DEPTHBIASCLAMP;
    public static final int FILLMODENONSOLID;
    public static final int DEPTHBOUNDS;
    public static final int WIDELINES;
    public static final int LARGEPOINTS;
    public static final int ALPHATOONE;
    public static final int MULTIVIEWPORT;
    public static final int SAMPLERANISOTROPY;
    public static final int TEXTURECOMPRESSIONETC2;
    public static final int TEXTURECOMPRESSIONASTC_LDR;
    public static final int TEXTURECOMPRESSIONBC;
    public static final int OCCLUSIONQUERYPRECISE;
    public static final int PIPELINESTATISTICSQUERY;
    public static final int VERTEXPIPELINESTORESANDATOMICS;
    public static final int FRAGMENTSTORESANDATOMICS;
    public static final int SHADERTESSELLATIONANDGEOMETRYPOINTSIZE;
    public static final int SHADERIMAGEGATHEREXTENDED;
    public static final int SHADERSTORAGEIMAGEEXTENDEDFORMATS;
    public static final int SHADERSTORAGEIMAGEMULTISAMPLE;
    public static final int SHADERSTORAGEIMAGEREADWITHOUTFORMAT;
    public static final int SHADERSTORAGEIMAGEWRITEWITHOUTFORMAT;
    public static final int SHADERUNIFORMBUFFERARRAYDYNAMICINDEXING;
    public static final int SHADERSAMPLEDIMAGEARRAYDYNAMICINDEXING;
    public static final int SHADERSTORAGEBUFFERARRAYDYNAMICINDEXING;
    public static final int SHADERSTORAGEIMAGEARRAYDYNAMICINDEXING;
    public static final int SHADERCLIPDISTANCE;
    public static final int SHADERCULLDISTANCE;
    public static final int SHADERFLOAT64;
    public static final int SHADERINT64;
    public static final int SHADERINT16;
    public static final int SHADERRESOURCERESIDENCY;
    public static final int SHADERRESOURCEMINLOD;
    public static final int SPARSEBINDING;
    public static final int SPARSERESIDENCYBUFFER;
    public static final int SPARSERESIDENCYIMAGE2D;
    public static final int SPARSERESIDENCYIMAGE3D;
    public static final int SPARSERESIDENCY2SAMPLES;
    public static final int SPARSERESIDENCY4SAMPLES;
    public static final int SPARSERESIDENCY8SAMPLES;
    public static final int SPARSERESIDENCY16SAMPLES;
    public static final int SPARSERESIDENCYALIASED;
    public static final int VARIABLEMULTISAMPLERATE;
    public static final int INHERITEDQUERIES;

    VkPhysicalDeviceFeatures(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceFeatures(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceFeatures.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean robustBufferAccess() {
        return VkPhysicalDeviceFeatures.nrobustBufferAccess(this.address()) != 0;
    }

    public boolean fullDrawIndexUint32() {
        return VkPhysicalDeviceFeatures.nfullDrawIndexUint32(this.address()) != 0;
    }

    public boolean imageCubeArray() {
        return VkPhysicalDeviceFeatures.nimageCubeArray(this.address()) != 0;
    }

    public boolean independentBlend() {
        return VkPhysicalDeviceFeatures.nindependentBlend(this.address()) != 0;
    }

    public boolean geometryShader() {
        return VkPhysicalDeviceFeatures.ngeometryShader(this.address()) != 0;
    }

    public boolean tessellationShader() {
        return VkPhysicalDeviceFeatures.ntessellationShader(this.address()) != 0;
    }

    public boolean sampleRateShading() {
        return VkPhysicalDeviceFeatures.nsampleRateShading(this.address()) != 0;
    }

    public boolean dualSrcBlend() {
        return VkPhysicalDeviceFeatures.ndualSrcBlend(this.address()) != 0;
    }

    public boolean logicOp() {
        return VkPhysicalDeviceFeatures.nlogicOp(this.address()) != 0;
    }

    public boolean multiDrawIndirect() {
        return VkPhysicalDeviceFeatures.nmultiDrawIndirect(this.address()) != 0;
    }

    public boolean drawIndirectFirstInstance() {
        return VkPhysicalDeviceFeatures.ndrawIndirectFirstInstance(this.address()) != 0;
    }

    public boolean depthClamp() {
        return VkPhysicalDeviceFeatures.ndepthClamp(this.address()) != 0;
    }

    public boolean depthBiasClamp() {
        return VkPhysicalDeviceFeatures.ndepthBiasClamp(this.address()) != 0;
    }

    public boolean fillModeNonSolid() {
        return VkPhysicalDeviceFeatures.nfillModeNonSolid(this.address()) != 0;
    }

    public boolean depthBounds() {
        return VkPhysicalDeviceFeatures.ndepthBounds(this.address()) != 0;
    }

    public boolean wideLines() {
        return VkPhysicalDeviceFeatures.nwideLines(this.address()) != 0;
    }

    public boolean largePoints() {
        return VkPhysicalDeviceFeatures.nlargePoints(this.address()) != 0;
    }

    public boolean alphaToOne() {
        return VkPhysicalDeviceFeatures.nalphaToOne(this.address()) != 0;
    }

    public boolean multiViewport() {
        return VkPhysicalDeviceFeatures.nmultiViewport(this.address()) != 0;
    }

    public boolean samplerAnisotropy() {
        return VkPhysicalDeviceFeatures.nsamplerAnisotropy(this.address()) != 0;
    }

    public boolean textureCompressionETC2() {
        return VkPhysicalDeviceFeatures.ntextureCompressionETC2(this.address()) != 0;
    }

    public boolean textureCompressionASTC_LDR() {
        return VkPhysicalDeviceFeatures.ntextureCompressionASTC_LDR(this.address()) != 0;
    }

    public boolean textureCompressionBC() {
        return VkPhysicalDeviceFeatures.ntextureCompressionBC(this.address()) != 0;
    }

    public boolean occlusionQueryPrecise() {
        return VkPhysicalDeviceFeatures.nocclusionQueryPrecise(this.address()) != 0;
    }

    public boolean pipelineStatisticsQuery() {
        return VkPhysicalDeviceFeatures.npipelineStatisticsQuery(this.address()) != 0;
    }

    public boolean vertexPipelineStoresAndAtomics() {
        return VkPhysicalDeviceFeatures.nvertexPipelineStoresAndAtomics(this.address()) != 0;
    }

    public boolean fragmentStoresAndAtomics() {
        return VkPhysicalDeviceFeatures.nfragmentStoresAndAtomics(this.address()) != 0;
    }

    public boolean shaderTessellationAndGeometryPointSize() {
        return VkPhysicalDeviceFeatures.nshaderTessellationAndGeometryPointSize(this.address()) != 0;
    }

    public boolean shaderImageGatherExtended() {
        return VkPhysicalDeviceFeatures.nshaderImageGatherExtended(this.address()) != 0;
    }

    public boolean shaderStorageImageExtendedFormats() {
        return VkPhysicalDeviceFeatures.nshaderStorageImageExtendedFormats(this.address()) != 0;
    }

    public boolean shaderStorageImageMultisample() {
        return VkPhysicalDeviceFeatures.nshaderStorageImageMultisample(this.address()) != 0;
    }

    public boolean shaderStorageImageReadWithoutFormat() {
        return VkPhysicalDeviceFeatures.nshaderStorageImageReadWithoutFormat(this.address()) != 0;
    }

    public boolean shaderStorageImageWriteWithoutFormat() {
        return VkPhysicalDeviceFeatures.nshaderStorageImageWriteWithoutFormat(this.address()) != 0;
    }

    public boolean shaderUniformBufferArrayDynamicIndexing() {
        return VkPhysicalDeviceFeatures.nshaderUniformBufferArrayDynamicIndexing(this.address()) != 0;
    }

    public boolean shaderSampledImageArrayDynamicIndexing() {
        return VkPhysicalDeviceFeatures.nshaderSampledImageArrayDynamicIndexing(this.address()) != 0;
    }

    public boolean shaderStorageBufferArrayDynamicIndexing() {
        return VkPhysicalDeviceFeatures.nshaderStorageBufferArrayDynamicIndexing(this.address()) != 0;
    }

    public boolean shaderStorageImageArrayDynamicIndexing() {
        return VkPhysicalDeviceFeatures.nshaderStorageImageArrayDynamicIndexing(this.address()) != 0;
    }

    public boolean shaderClipDistance() {
        return VkPhysicalDeviceFeatures.nshaderClipDistance(this.address()) != 0;
    }

    public boolean shaderCullDistance() {
        return VkPhysicalDeviceFeatures.nshaderCullDistance(this.address()) != 0;
    }

    public boolean shaderFloat64() {
        return VkPhysicalDeviceFeatures.nshaderFloat64(this.address()) != 0;
    }

    public boolean shaderInt64() {
        return VkPhysicalDeviceFeatures.nshaderInt64(this.address()) != 0;
    }

    public boolean shaderInt16() {
        return VkPhysicalDeviceFeatures.nshaderInt16(this.address()) != 0;
    }

    public boolean shaderResourceResidency() {
        return VkPhysicalDeviceFeatures.nshaderResourceResidency(this.address()) != 0;
    }

    public boolean shaderResourceMinLod() {
        return VkPhysicalDeviceFeatures.nshaderResourceMinLod(this.address()) != 0;
    }

    public boolean sparseBinding() {
        return VkPhysicalDeviceFeatures.nsparseBinding(this.address()) != 0;
    }

    public boolean sparseResidencyBuffer() {
        return VkPhysicalDeviceFeatures.nsparseResidencyBuffer(this.address()) != 0;
    }

    public boolean sparseResidencyImage2D() {
        return VkPhysicalDeviceFeatures.nsparseResidencyImage2D(this.address()) != 0;
    }

    public boolean sparseResidencyImage3D() {
        return VkPhysicalDeviceFeatures.nsparseResidencyImage3D(this.address()) != 0;
    }

    public boolean sparseResidency2Samples() {
        return VkPhysicalDeviceFeatures.nsparseResidency2Samples(this.address()) != 0;
    }

    public boolean sparseResidency4Samples() {
        return VkPhysicalDeviceFeatures.nsparseResidency4Samples(this.address()) != 0;
    }

    public boolean sparseResidency8Samples() {
        return VkPhysicalDeviceFeatures.nsparseResidency8Samples(this.address()) != 0;
    }

    public boolean sparseResidency16Samples() {
        return VkPhysicalDeviceFeatures.nsparseResidency16Samples(this.address()) != 0;
    }

    public boolean sparseResidencyAliased() {
        return VkPhysicalDeviceFeatures.nsparseResidencyAliased(this.address()) != 0;
    }

    public boolean variableMultisampleRate() {
        return VkPhysicalDeviceFeatures.nvariableMultisampleRate(this.address()) != 0;
    }

    public boolean inheritedQueries() {
        return VkPhysicalDeviceFeatures.ninheritedQueries(this.address()) != 0;
    }

    public VkPhysicalDeviceFeatures robustBufferAccess(boolean value) {
        VkPhysicalDeviceFeatures.nrobustBufferAccess(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures fullDrawIndexUint32(boolean value) {
        VkPhysicalDeviceFeatures.nfullDrawIndexUint32(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures imageCubeArray(boolean value) {
        VkPhysicalDeviceFeatures.nimageCubeArray(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures independentBlend(boolean value) {
        VkPhysicalDeviceFeatures.nindependentBlend(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures geometryShader(boolean value) {
        VkPhysicalDeviceFeatures.ngeometryShader(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures tessellationShader(boolean value) {
        VkPhysicalDeviceFeatures.ntessellationShader(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sampleRateShading(boolean value) {
        VkPhysicalDeviceFeatures.nsampleRateShading(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures dualSrcBlend(boolean value) {
        VkPhysicalDeviceFeatures.ndualSrcBlend(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures logicOp(boolean value) {
        VkPhysicalDeviceFeatures.nlogicOp(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures multiDrawIndirect(boolean value) {
        VkPhysicalDeviceFeatures.nmultiDrawIndirect(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures drawIndirectFirstInstance(boolean value) {
        VkPhysicalDeviceFeatures.ndrawIndirectFirstInstance(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures depthClamp(boolean value) {
        VkPhysicalDeviceFeatures.ndepthClamp(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures depthBiasClamp(boolean value) {
        VkPhysicalDeviceFeatures.ndepthBiasClamp(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures fillModeNonSolid(boolean value) {
        VkPhysicalDeviceFeatures.nfillModeNonSolid(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures depthBounds(boolean value) {
        VkPhysicalDeviceFeatures.ndepthBounds(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures wideLines(boolean value) {
        VkPhysicalDeviceFeatures.nwideLines(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures largePoints(boolean value) {
        VkPhysicalDeviceFeatures.nlargePoints(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures alphaToOne(boolean value) {
        VkPhysicalDeviceFeatures.nalphaToOne(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures multiViewport(boolean value) {
        VkPhysicalDeviceFeatures.nmultiViewport(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures samplerAnisotropy(boolean value) {
        VkPhysicalDeviceFeatures.nsamplerAnisotropy(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures textureCompressionETC2(boolean value) {
        VkPhysicalDeviceFeatures.ntextureCompressionETC2(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures textureCompressionASTC_LDR(boolean value) {
        VkPhysicalDeviceFeatures.ntextureCompressionASTC_LDR(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures textureCompressionBC(boolean value) {
        VkPhysicalDeviceFeatures.ntextureCompressionBC(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures occlusionQueryPrecise(boolean value) {
        VkPhysicalDeviceFeatures.nocclusionQueryPrecise(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures pipelineStatisticsQuery(boolean value) {
        VkPhysicalDeviceFeatures.npipelineStatisticsQuery(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures vertexPipelineStoresAndAtomics(boolean value) {
        VkPhysicalDeviceFeatures.nvertexPipelineStoresAndAtomics(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures fragmentStoresAndAtomics(boolean value) {
        VkPhysicalDeviceFeatures.nfragmentStoresAndAtomics(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderTessellationAndGeometryPointSize(boolean value) {
        VkPhysicalDeviceFeatures.nshaderTessellationAndGeometryPointSize(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderImageGatherExtended(boolean value) {
        VkPhysicalDeviceFeatures.nshaderImageGatherExtended(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderStorageImageExtendedFormats(boolean value) {
        VkPhysicalDeviceFeatures.nshaderStorageImageExtendedFormats(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderStorageImageMultisample(boolean value) {
        VkPhysicalDeviceFeatures.nshaderStorageImageMultisample(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderStorageImageReadWithoutFormat(boolean value) {
        VkPhysicalDeviceFeatures.nshaderStorageImageReadWithoutFormat(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderStorageImageWriteWithoutFormat(boolean value) {
        VkPhysicalDeviceFeatures.nshaderStorageImageWriteWithoutFormat(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderUniformBufferArrayDynamicIndexing(boolean value) {
        VkPhysicalDeviceFeatures.nshaderUniformBufferArrayDynamicIndexing(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderSampledImageArrayDynamicIndexing(boolean value) {
        VkPhysicalDeviceFeatures.nshaderSampledImageArrayDynamicIndexing(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderStorageBufferArrayDynamicIndexing(boolean value) {
        VkPhysicalDeviceFeatures.nshaderStorageBufferArrayDynamicIndexing(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderStorageImageArrayDynamicIndexing(boolean value) {
        VkPhysicalDeviceFeatures.nshaderStorageImageArrayDynamicIndexing(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderClipDistance(boolean value) {
        VkPhysicalDeviceFeatures.nshaderClipDistance(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderCullDistance(boolean value) {
        VkPhysicalDeviceFeatures.nshaderCullDistance(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderFloat64(boolean value) {
        VkPhysicalDeviceFeatures.nshaderFloat64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderInt64(boolean value) {
        VkPhysicalDeviceFeatures.nshaderInt64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderInt16(boolean value) {
        VkPhysicalDeviceFeatures.nshaderInt16(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderResourceResidency(boolean value) {
        VkPhysicalDeviceFeatures.nshaderResourceResidency(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures shaderResourceMinLod(boolean value) {
        VkPhysicalDeviceFeatures.nshaderResourceMinLod(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseBinding(boolean value) {
        VkPhysicalDeviceFeatures.nsparseBinding(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidencyBuffer(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidencyBuffer(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidencyImage2D(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidencyImage2D(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidencyImage3D(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidencyImage3D(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidency2Samples(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidency2Samples(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidency4Samples(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidency4Samples(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidency8Samples(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidency8Samples(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidency16Samples(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidency16Samples(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures sparseResidencyAliased(boolean value) {
        VkPhysicalDeviceFeatures.nsparseResidencyAliased(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures variableMultisampleRate(boolean value) {
        VkPhysicalDeviceFeatures.nvariableMultisampleRate(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures inheritedQueries(boolean value) {
        VkPhysicalDeviceFeatures.ninheritedQueries(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceFeatures set(boolean robustBufferAccess, boolean fullDrawIndexUint32, boolean imageCubeArray, boolean independentBlend, boolean geometryShader, boolean tessellationShader, boolean sampleRateShading, boolean dualSrcBlend, boolean logicOp, boolean multiDrawIndirect, boolean drawIndirectFirstInstance, boolean depthClamp, boolean depthBiasClamp, boolean fillModeNonSolid, boolean depthBounds, boolean wideLines, boolean largePoints, boolean alphaToOne, boolean multiViewport, boolean samplerAnisotropy, boolean textureCompressionETC2, boolean textureCompressionASTC_LDR, boolean textureCompressionBC, boolean occlusionQueryPrecise, boolean pipelineStatisticsQuery, boolean vertexPipelineStoresAndAtomics, boolean fragmentStoresAndAtomics, boolean shaderTessellationAndGeometryPointSize, boolean shaderImageGatherExtended, boolean shaderStorageImageExtendedFormats, boolean shaderStorageImageMultisample, boolean shaderStorageImageReadWithoutFormat, boolean shaderStorageImageWriteWithoutFormat, boolean shaderUniformBufferArrayDynamicIndexing, boolean shaderSampledImageArrayDynamicIndexing, boolean shaderStorageBufferArrayDynamicIndexing, boolean shaderStorageImageArrayDynamicIndexing, boolean shaderClipDistance, boolean shaderCullDistance, boolean shaderFloat64, boolean shaderInt64, boolean shaderInt16, boolean shaderResourceResidency, boolean shaderResourceMinLod, boolean sparseBinding, boolean sparseResidencyBuffer, boolean sparseResidencyImage2D, boolean sparseResidencyImage3D, boolean sparseResidency2Samples, boolean sparseResidency4Samples, boolean sparseResidency8Samples, boolean sparseResidency16Samples, boolean sparseResidencyAliased, boolean variableMultisampleRate, boolean inheritedQueries) {
        this.robustBufferAccess(robustBufferAccess);
        this.fullDrawIndexUint32(fullDrawIndexUint32);
        this.imageCubeArray(imageCubeArray);
        this.independentBlend(independentBlend);
        this.geometryShader(geometryShader);
        this.tessellationShader(tessellationShader);
        this.sampleRateShading(sampleRateShading);
        this.dualSrcBlend(dualSrcBlend);
        this.logicOp(logicOp);
        this.multiDrawIndirect(multiDrawIndirect);
        this.drawIndirectFirstInstance(drawIndirectFirstInstance);
        this.depthClamp(depthClamp);
        this.depthBiasClamp(depthBiasClamp);
        this.fillModeNonSolid(fillModeNonSolid);
        this.depthBounds(depthBounds);
        this.wideLines(wideLines);
        this.largePoints(largePoints);
        this.alphaToOne(alphaToOne);
        this.multiViewport(multiViewport);
        this.samplerAnisotropy(samplerAnisotropy);
        this.textureCompressionETC2(textureCompressionETC2);
        this.textureCompressionASTC_LDR(textureCompressionASTC_LDR);
        this.textureCompressionBC(textureCompressionBC);
        this.occlusionQueryPrecise(occlusionQueryPrecise);
        this.pipelineStatisticsQuery(pipelineStatisticsQuery);
        this.vertexPipelineStoresAndAtomics(vertexPipelineStoresAndAtomics);
        this.fragmentStoresAndAtomics(fragmentStoresAndAtomics);
        this.shaderTessellationAndGeometryPointSize(shaderTessellationAndGeometryPointSize);
        this.shaderImageGatherExtended(shaderImageGatherExtended);
        this.shaderStorageImageExtendedFormats(shaderStorageImageExtendedFormats);
        this.shaderStorageImageMultisample(shaderStorageImageMultisample);
        this.shaderStorageImageReadWithoutFormat(shaderStorageImageReadWithoutFormat);
        this.shaderStorageImageWriteWithoutFormat(shaderStorageImageWriteWithoutFormat);
        this.shaderUniformBufferArrayDynamicIndexing(shaderUniformBufferArrayDynamicIndexing);
        this.shaderSampledImageArrayDynamicIndexing(shaderSampledImageArrayDynamicIndexing);
        this.shaderStorageBufferArrayDynamicIndexing(shaderStorageBufferArrayDynamicIndexing);
        this.shaderStorageImageArrayDynamicIndexing(shaderStorageImageArrayDynamicIndexing);
        this.shaderClipDistance(shaderClipDistance);
        this.shaderCullDistance(shaderCullDistance);
        this.shaderFloat64(shaderFloat64);
        this.shaderInt64(shaderInt64);
        this.shaderInt16(shaderInt16);
        this.shaderResourceResidency(shaderResourceResidency);
        this.shaderResourceMinLod(shaderResourceMinLod);
        this.sparseBinding(sparseBinding);
        this.sparseResidencyBuffer(sparseResidencyBuffer);
        this.sparseResidencyImage2D(sparseResidencyImage2D);
        this.sparseResidencyImage3D(sparseResidencyImage3D);
        this.sparseResidency2Samples(sparseResidency2Samples);
        this.sparseResidency4Samples(sparseResidency4Samples);
        this.sparseResidency8Samples(sparseResidency8Samples);
        this.sparseResidency16Samples(sparseResidency16Samples);
        this.sparseResidencyAliased(sparseResidencyAliased);
        this.variableMultisampleRate(variableMultisampleRate);
        this.inheritedQueries(inheritedQueries);
        return this;
    }

    public VkPhysicalDeviceFeatures set(VkPhysicalDeviceFeatures src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceFeatures malloc() {
        return VkPhysicalDeviceFeatures.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPhysicalDeviceFeatures calloc() {
        return VkPhysicalDeviceFeatures.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPhysicalDeviceFeatures create() {
        return new VkPhysicalDeviceFeatures(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceFeatures create(long address) {
        return address == 0L ? null : new VkPhysicalDeviceFeatures(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceFeatures.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceFeatures.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPhysicalDeviceFeatures mallocStack() {
        return VkPhysicalDeviceFeatures.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceFeatures callocStack() {
        return VkPhysicalDeviceFeatures.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceFeatures mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceFeatures.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceFeatures callocStack(MemoryStack stack) {
        return VkPhysicalDeviceFeatures.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceFeatures.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceFeatures.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceFeatures.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceFeatures.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nrobustBufferAccess(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ROBUSTBUFFERACCESS);
    }

    public static int nfullDrawIndexUint32(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FULLDRAWINDEXUINT32);
    }

    public static int nimageCubeArray(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGECUBEARRAY);
    }

    public static int nindependentBlend(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEPENDENTBLEND);
    }

    public static int ngeometryShader(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GEOMETRYSHADER);
    }

    public static int ntessellationShader(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TESSELLATIONSHADER);
    }

    public static int nsampleRateShading(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLERATESHADING);
    }

    public static int ndualSrcBlend(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DUALSRCBLEND);
    }

    public static int nlogicOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOGICOP);
    }

    public static int nmultiDrawIndirect(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MULTIDRAWINDIRECT);
    }

    public static int ndrawIndirectFirstInstance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DRAWINDIRECTFIRSTINSTANCE);
    }

    public static int ndepthClamp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHCLAMP);
    }

    public static int ndepthBiasClamp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHBIASCLAMP);
    }

    public static int nfillModeNonSolid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FILLMODENONSOLID);
    }

    public static int ndepthBounds(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHBOUNDS);
    }

    public static int nwideLines(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDELINES);
    }

    public static int nlargePoints(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LARGEPOINTS);
    }

    public static int nalphaToOne(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALPHATOONE);
    }

    public static int nmultiViewport(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MULTIVIEWPORT);
    }

    public static int nsamplerAnisotropy(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLERANISOTROPY);
    }

    public static int ntextureCompressionETC2(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURECOMPRESSIONETC2);
    }

    public static int ntextureCompressionASTC_LDR(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURECOMPRESSIONASTC_LDR);
    }

    public static int ntextureCompressionBC(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURECOMPRESSIONBC);
    }

    public static int nocclusionQueryPrecise(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OCCLUSIONQUERYPRECISE);
    }

    public static int npipelineStatisticsQuery(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINESTATISTICSQUERY);
    }

    public static int nvertexPipelineStoresAndAtomics(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXPIPELINESTORESANDATOMICS);
    }

    public static int nfragmentStoresAndAtomics(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAGMENTSTORESANDATOMICS);
    }

    public static int nshaderTessellationAndGeometryPointSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERTESSELLATIONANDGEOMETRYPOINTSIZE);
    }

    public static int nshaderImageGatherExtended(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERIMAGEGATHEREXTENDED);
    }

    public static int nshaderStorageImageExtendedFormats(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTORAGEIMAGEEXTENDEDFORMATS);
    }

    public static int nshaderStorageImageMultisample(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTORAGEIMAGEMULTISAMPLE);
    }

    public static int nshaderStorageImageReadWithoutFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTORAGEIMAGEREADWITHOUTFORMAT);
    }

    public static int nshaderStorageImageWriteWithoutFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTORAGEIMAGEWRITEWITHOUTFORMAT);
    }

    public static int nshaderUniformBufferArrayDynamicIndexing(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERUNIFORMBUFFERARRAYDYNAMICINDEXING);
    }

    public static int nshaderSampledImageArrayDynamicIndexing(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSAMPLEDIMAGEARRAYDYNAMICINDEXING);
    }

    public static int nshaderStorageBufferArrayDynamicIndexing(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTORAGEBUFFERARRAYDYNAMICINDEXING);
    }

    public static int nshaderStorageImageArrayDynamicIndexing(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTORAGEIMAGEARRAYDYNAMICINDEXING);
    }

    public static int nshaderClipDistance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERCLIPDISTANCE);
    }

    public static int nshaderCullDistance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERCULLDISTANCE);
    }

    public static int nshaderFloat64(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERFLOAT64);
    }

    public static int nshaderInt64(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERINT64);
    }

    public static int nshaderInt16(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERINT16);
    }

    public static int nshaderResourceResidency(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERRESOURCERESIDENCY);
    }

    public static int nshaderResourceMinLod(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERRESOURCEMINLOD);
    }

    public static int nsparseBinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSEBINDING);
    }

    public static int nsparseResidencyBuffer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCYBUFFER);
    }

    public static int nsparseResidencyImage2D(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCYIMAGE2D);
    }

    public static int nsparseResidencyImage3D(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCYIMAGE3D);
    }

    public static int nsparseResidency2Samples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCY2SAMPLES);
    }

    public static int nsparseResidency4Samples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCY4SAMPLES);
    }

    public static int nsparseResidency8Samples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCY8SAMPLES);
    }

    public static int nsparseResidency16Samples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCY16SAMPLES);
    }

    public static int nsparseResidencyAliased(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPARSERESIDENCYALIASED);
    }

    public static int nvariableMultisampleRate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VARIABLEMULTISAMPLERATE);
    }

    public static int ninheritedQueries(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INHERITEDQUERIES);
    }

    public static void nrobustBufferAccess(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ROBUSTBUFFERACCESS, value);
    }

    public static void nfullDrawIndexUint32(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FULLDRAWINDEXUINT32, value);
    }

    public static void nimageCubeArray(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGECUBEARRAY, value);
    }

    public static void nindependentBlend(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEPENDENTBLEND, value);
    }

    public static void ngeometryShader(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GEOMETRYSHADER, value);
    }

    public static void ntessellationShader(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TESSELLATIONSHADER, value);
    }

    public static void nsampleRateShading(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLERATESHADING, value);
    }

    public static void ndualSrcBlend(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DUALSRCBLEND, value);
    }

    public static void nlogicOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOGICOP, value);
    }

    public static void nmultiDrawIndirect(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MULTIDRAWINDIRECT, value);
    }

    public static void ndrawIndirectFirstInstance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DRAWINDIRECTFIRSTINSTANCE, value);
    }

    public static void ndepthClamp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHCLAMP, value);
    }

    public static void ndepthBiasClamp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHBIASCLAMP, value);
    }

    public static void nfillModeNonSolid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FILLMODENONSOLID, value);
    }

    public static void ndepthBounds(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHBOUNDS, value);
    }

    public static void nwideLines(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDELINES, value);
    }

    public static void nlargePoints(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LARGEPOINTS, value);
    }

    public static void nalphaToOne(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALPHATOONE, value);
    }

    public static void nmultiViewport(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MULTIVIEWPORT, value);
    }

    public static void nsamplerAnisotropy(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLERANISOTROPY, value);
    }

    public static void ntextureCompressionETC2(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXTURECOMPRESSIONETC2, value);
    }

    public static void ntextureCompressionASTC_LDR(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXTURECOMPRESSIONASTC_LDR, value);
    }

    public static void ntextureCompressionBC(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXTURECOMPRESSIONBC, value);
    }

    public static void nocclusionQueryPrecise(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OCCLUSIONQUERYPRECISE, value);
    }

    public static void npipelineStatisticsQuery(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINESTATISTICSQUERY, value);
    }

    public static void nvertexPipelineStoresAndAtomics(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXPIPELINESTORESANDATOMICS, value);
    }

    public static void nfragmentStoresAndAtomics(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAGMENTSTORESANDATOMICS, value);
    }

    public static void nshaderTessellationAndGeometryPointSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERTESSELLATIONANDGEOMETRYPOINTSIZE, value);
    }

    public static void nshaderImageGatherExtended(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERIMAGEGATHEREXTENDED, value);
    }

    public static void nshaderStorageImageExtendedFormats(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSTORAGEIMAGEEXTENDEDFORMATS, value);
    }

    public static void nshaderStorageImageMultisample(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSTORAGEIMAGEMULTISAMPLE, value);
    }

    public static void nshaderStorageImageReadWithoutFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSTORAGEIMAGEREADWITHOUTFORMAT, value);
    }

    public static void nshaderStorageImageWriteWithoutFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSTORAGEIMAGEWRITEWITHOUTFORMAT, value);
    }

    public static void nshaderUniformBufferArrayDynamicIndexing(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERUNIFORMBUFFERARRAYDYNAMICINDEXING, value);
    }

    public static void nshaderSampledImageArrayDynamicIndexing(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSAMPLEDIMAGEARRAYDYNAMICINDEXING, value);
    }

    public static void nshaderStorageBufferArrayDynamicIndexing(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSTORAGEBUFFERARRAYDYNAMICINDEXING, value);
    }

    public static void nshaderStorageImageArrayDynamicIndexing(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERSTORAGEIMAGEARRAYDYNAMICINDEXING, value);
    }

    public static void nshaderClipDistance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERCLIPDISTANCE, value);
    }

    public static void nshaderCullDistance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERCULLDISTANCE, value);
    }

    public static void nshaderFloat64(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERFLOAT64, value);
    }

    public static void nshaderInt64(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERINT64, value);
    }

    public static void nshaderInt16(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERINT16, value);
    }

    public static void nshaderResourceResidency(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERRESOURCERESIDENCY, value);
    }

    public static void nshaderResourceMinLod(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERRESOURCEMINLOD, value);
    }

    public static void nsparseBinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSEBINDING, value);
    }

    public static void nsparseResidencyBuffer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCYBUFFER, value);
    }

    public static void nsparseResidencyImage2D(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCYIMAGE2D, value);
    }

    public static void nsparseResidencyImage3D(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCYIMAGE3D, value);
    }

    public static void nsparseResidency2Samples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCY2SAMPLES, value);
    }

    public static void nsparseResidency4Samples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCY4SAMPLES, value);
    }

    public static void nsparseResidency8Samples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCY8SAMPLES, value);
    }

    public static void nsparseResidency16Samples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCY16SAMPLES, value);
    }

    public static void nsparseResidencyAliased(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPARSERESIDENCYALIASED, value);
    }

    public static void nvariableMultisampleRate(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VARIABLEMULTISAMPLERATE, value);
    }

    public static void ninheritedQueries(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INHERITEDQUERIES, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceFeatures.__struct(VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4), VkPhysicalDeviceFeatures.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ROBUSTBUFFERACCESS = layout.offsetof(0);
        FULLDRAWINDEXUINT32 = layout.offsetof(1);
        IMAGECUBEARRAY = layout.offsetof(2);
        INDEPENDENTBLEND = layout.offsetof(3);
        GEOMETRYSHADER = layout.offsetof(4);
        TESSELLATIONSHADER = layout.offsetof(5);
        SAMPLERATESHADING = layout.offsetof(6);
        DUALSRCBLEND = layout.offsetof(7);
        LOGICOP = layout.offsetof(8);
        MULTIDRAWINDIRECT = layout.offsetof(9);
        DRAWINDIRECTFIRSTINSTANCE = layout.offsetof(10);
        DEPTHCLAMP = layout.offsetof(11);
        DEPTHBIASCLAMP = layout.offsetof(12);
        FILLMODENONSOLID = layout.offsetof(13);
        DEPTHBOUNDS = layout.offsetof(14);
        WIDELINES = layout.offsetof(15);
        LARGEPOINTS = layout.offsetof(16);
        ALPHATOONE = layout.offsetof(17);
        MULTIVIEWPORT = layout.offsetof(18);
        SAMPLERANISOTROPY = layout.offsetof(19);
        TEXTURECOMPRESSIONETC2 = layout.offsetof(20);
        TEXTURECOMPRESSIONASTC_LDR = layout.offsetof(21);
        TEXTURECOMPRESSIONBC = layout.offsetof(22);
        OCCLUSIONQUERYPRECISE = layout.offsetof(23);
        PIPELINESTATISTICSQUERY = layout.offsetof(24);
        VERTEXPIPELINESTORESANDATOMICS = layout.offsetof(25);
        FRAGMENTSTORESANDATOMICS = layout.offsetof(26);
        SHADERTESSELLATIONANDGEOMETRYPOINTSIZE = layout.offsetof(27);
        SHADERIMAGEGATHEREXTENDED = layout.offsetof(28);
        SHADERSTORAGEIMAGEEXTENDEDFORMATS = layout.offsetof(29);
        SHADERSTORAGEIMAGEMULTISAMPLE = layout.offsetof(30);
        SHADERSTORAGEIMAGEREADWITHOUTFORMAT = layout.offsetof(31);
        SHADERSTORAGEIMAGEWRITEWITHOUTFORMAT = layout.offsetof(32);
        SHADERUNIFORMBUFFERARRAYDYNAMICINDEXING = layout.offsetof(33);
        SHADERSAMPLEDIMAGEARRAYDYNAMICINDEXING = layout.offsetof(34);
        SHADERSTORAGEBUFFERARRAYDYNAMICINDEXING = layout.offsetof(35);
        SHADERSTORAGEIMAGEARRAYDYNAMICINDEXING = layout.offsetof(36);
        SHADERCLIPDISTANCE = layout.offsetof(37);
        SHADERCULLDISTANCE = layout.offsetof(38);
        SHADERFLOAT64 = layout.offsetof(39);
        SHADERINT64 = layout.offsetof(40);
        SHADERINT16 = layout.offsetof(41);
        SHADERRESOURCERESIDENCY = layout.offsetof(42);
        SHADERRESOURCEMINLOD = layout.offsetof(43);
        SPARSEBINDING = layout.offsetof(44);
        SPARSERESIDENCYBUFFER = layout.offsetof(45);
        SPARSERESIDENCYIMAGE2D = layout.offsetof(46);
        SPARSERESIDENCYIMAGE3D = layout.offsetof(47);
        SPARSERESIDENCY2SAMPLES = layout.offsetof(48);
        SPARSERESIDENCY4SAMPLES = layout.offsetof(49);
        SPARSERESIDENCY8SAMPLES = layout.offsetof(50);
        SPARSERESIDENCY16SAMPLES = layout.offsetof(51);
        SPARSERESIDENCYALIASED = layout.offsetof(52);
        VARIABLEMULTISAMPLERATE = layout.offsetof(53);
        INHERITEDQUERIES = layout.offsetof(54);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceFeatures, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceFeatures newInstance(long address) {
            return new VkPhysicalDeviceFeatures(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean robustBufferAccess() {
            return VkPhysicalDeviceFeatures.nrobustBufferAccess(this.address()) != 0;
        }

        public boolean fullDrawIndexUint32() {
            return VkPhysicalDeviceFeatures.nfullDrawIndexUint32(this.address()) != 0;
        }

        public boolean imageCubeArray() {
            return VkPhysicalDeviceFeatures.nimageCubeArray(this.address()) != 0;
        }

        public boolean independentBlend() {
            return VkPhysicalDeviceFeatures.nindependentBlend(this.address()) != 0;
        }

        public boolean geometryShader() {
            return VkPhysicalDeviceFeatures.ngeometryShader(this.address()) != 0;
        }

        public boolean tessellationShader() {
            return VkPhysicalDeviceFeatures.ntessellationShader(this.address()) != 0;
        }

        public boolean sampleRateShading() {
            return VkPhysicalDeviceFeatures.nsampleRateShading(this.address()) != 0;
        }

        public boolean dualSrcBlend() {
            return VkPhysicalDeviceFeatures.ndualSrcBlend(this.address()) != 0;
        }

        public boolean logicOp() {
            return VkPhysicalDeviceFeatures.nlogicOp(this.address()) != 0;
        }

        public boolean multiDrawIndirect() {
            return VkPhysicalDeviceFeatures.nmultiDrawIndirect(this.address()) != 0;
        }

        public boolean drawIndirectFirstInstance() {
            return VkPhysicalDeviceFeatures.ndrawIndirectFirstInstance(this.address()) != 0;
        }

        public boolean depthClamp() {
            return VkPhysicalDeviceFeatures.ndepthClamp(this.address()) != 0;
        }

        public boolean depthBiasClamp() {
            return VkPhysicalDeviceFeatures.ndepthBiasClamp(this.address()) != 0;
        }

        public boolean fillModeNonSolid() {
            return VkPhysicalDeviceFeatures.nfillModeNonSolid(this.address()) != 0;
        }

        public boolean depthBounds() {
            return VkPhysicalDeviceFeatures.ndepthBounds(this.address()) != 0;
        }

        public boolean wideLines() {
            return VkPhysicalDeviceFeatures.nwideLines(this.address()) != 0;
        }

        public boolean largePoints() {
            return VkPhysicalDeviceFeatures.nlargePoints(this.address()) != 0;
        }

        public boolean alphaToOne() {
            return VkPhysicalDeviceFeatures.nalphaToOne(this.address()) != 0;
        }

        public boolean multiViewport() {
            return VkPhysicalDeviceFeatures.nmultiViewport(this.address()) != 0;
        }

        public boolean samplerAnisotropy() {
            return VkPhysicalDeviceFeatures.nsamplerAnisotropy(this.address()) != 0;
        }

        public boolean textureCompressionETC2() {
            return VkPhysicalDeviceFeatures.ntextureCompressionETC2(this.address()) != 0;
        }

        public boolean textureCompressionASTC_LDR() {
            return VkPhysicalDeviceFeatures.ntextureCompressionASTC_LDR(this.address()) != 0;
        }

        public boolean textureCompressionBC() {
            return VkPhysicalDeviceFeatures.ntextureCompressionBC(this.address()) != 0;
        }

        public boolean occlusionQueryPrecise() {
            return VkPhysicalDeviceFeatures.nocclusionQueryPrecise(this.address()) != 0;
        }

        public boolean pipelineStatisticsQuery() {
            return VkPhysicalDeviceFeatures.npipelineStatisticsQuery(this.address()) != 0;
        }

        public boolean vertexPipelineStoresAndAtomics() {
            return VkPhysicalDeviceFeatures.nvertexPipelineStoresAndAtomics(this.address()) != 0;
        }

        public boolean fragmentStoresAndAtomics() {
            return VkPhysicalDeviceFeatures.nfragmentStoresAndAtomics(this.address()) != 0;
        }

        public boolean shaderTessellationAndGeometryPointSize() {
            return VkPhysicalDeviceFeatures.nshaderTessellationAndGeometryPointSize(this.address()) != 0;
        }

        public boolean shaderImageGatherExtended() {
            return VkPhysicalDeviceFeatures.nshaderImageGatherExtended(this.address()) != 0;
        }

        public boolean shaderStorageImageExtendedFormats() {
            return VkPhysicalDeviceFeatures.nshaderStorageImageExtendedFormats(this.address()) != 0;
        }

        public boolean shaderStorageImageMultisample() {
            return VkPhysicalDeviceFeatures.nshaderStorageImageMultisample(this.address()) != 0;
        }

        public boolean shaderStorageImageReadWithoutFormat() {
            return VkPhysicalDeviceFeatures.nshaderStorageImageReadWithoutFormat(this.address()) != 0;
        }

        public boolean shaderStorageImageWriteWithoutFormat() {
            return VkPhysicalDeviceFeatures.nshaderStorageImageWriteWithoutFormat(this.address()) != 0;
        }

        public boolean shaderUniformBufferArrayDynamicIndexing() {
            return VkPhysicalDeviceFeatures.nshaderUniformBufferArrayDynamicIndexing(this.address()) != 0;
        }

        public boolean shaderSampledImageArrayDynamicIndexing() {
            return VkPhysicalDeviceFeatures.nshaderSampledImageArrayDynamicIndexing(this.address()) != 0;
        }

        public boolean shaderStorageBufferArrayDynamicIndexing() {
            return VkPhysicalDeviceFeatures.nshaderStorageBufferArrayDynamicIndexing(this.address()) != 0;
        }

        public boolean shaderStorageImageArrayDynamicIndexing() {
            return VkPhysicalDeviceFeatures.nshaderStorageImageArrayDynamicIndexing(this.address()) != 0;
        }

        public boolean shaderClipDistance() {
            return VkPhysicalDeviceFeatures.nshaderClipDistance(this.address()) != 0;
        }

        public boolean shaderCullDistance() {
            return VkPhysicalDeviceFeatures.nshaderCullDistance(this.address()) != 0;
        }

        public boolean shaderFloat64() {
            return VkPhysicalDeviceFeatures.nshaderFloat64(this.address()) != 0;
        }

        public boolean shaderInt64() {
            return VkPhysicalDeviceFeatures.nshaderInt64(this.address()) != 0;
        }

        public boolean shaderInt16() {
            return VkPhysicalDeviceFeatures.nshaderInt16(this.address()) != 0;
        }

        public boolean shaderResourceResidency() {
            return VkPhysicalDeviceFeatures.nshaderResourceResidency(this.address()) != 0;
        }

        public boolean shaderResourceMinLod() {
            return VkPhysicalDeviceFeatures.nshaderResourceMinLod(this.address()) != 0;
        }

        public boolean sparseBinding() {
            return VkPhysicalDeviceFeatures.nsparseBinding(this.address()) != 0;
        }

        public boolean sparseResidencyBuffer() {
            return VkPhysicalDeviceFeatures.nsparseResidencyBuffer(this.address()) != 0;
        }

        public boolean sparseResidencyImage2D() {
            return VkPhysicalDeviceFeatures.nsparseResidencyImage2D(this.address()) != 0;
        }

        public boolean sparseResidencyImage3D() {
            return VkPhysicalDeviceFeatures.nsparseResidencyImage3D(this.address()) != 0;
        }

        public boolean sparseResidency2Samples() {
            return VkPhysicalDeviceFeatures.nsparseResidency2Samples(this.address()) != 0;
        }

        public boolean sparseResidency4Samples() {
            return VkPhysicalDeviceFeatures.nsparseResidency4Samples(this.address()) != 0;
        }

        public boolean sparseResidency8Samples() {
            return VkPhysicalDeviceFeatures.nsparseResidency8Samples(this.address()) != 0;
        }

        public boolean sparseResidency16Samples() {
            return VkPhysicalDeviceFeatures.nsparseResidency16Samples(this.address()) != 0;
        }

        public boolean sparseResidencyAliased() {
            return VkPhysicalDeviceFeatures.nsparseResidencyAliased(this.address()) != 0;
        }

        public boolean variableMultisampleRate() {
            return VkPhysicalDeviceFeatures.nvariableMultisampleRate(this.address()) != 0;
        }

        public boolean inheritedQueries() {
            return VkPhysicalDeviceFeatures.ninheritedQueries(this.address()) != 0;
        }

        public Buffer robustBufferAccess(boolean value) {
            VkPhysicalDeviceFeatures.nrobustBufferAccess(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer fullDrawIndexUint32(boolean value) {
            VkPhysicalDeviceFeatures.nfullDrawIndexUint32(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer imageCubeArray(boolean value) {
            VkPhysicalDeviceFeatures.nimageCubeArray(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer independentBlend(boolean value) {
            VkPhysicalDeviceFeatures.nindependentBlend(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer geometryShader(boolean value) {
            VkPhysicalDeviceFeatures.ngeometryShader(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer tessellationShader(boolean value) {
            VkPhysicalDeviceFeatures.ntessellationShader(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sampleRateShading(boolean value) {
            VkPhysicalDeviceFeatures.nsampleRateShading(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer dualSrcBlend(boolean value) {
            VkPhysicalDeviceFeatures.ndualSrcBlend(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer logicOp(boolean value) {
            VkPhysicalDeviceFeatures.nlogicOp(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer multiDrawIndirect(boolean value) {
            VkPhysicalDeviceFeatures.nmultiDrawIndirect(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer drawIndirectFirstInstance(boolean value) {
            VkPhysicalDeviceFeatures.ndrawIndirectFirstInstance(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthClamp(boolean value) {
            VkPhysicalDeviceFeatures.ndepthClamp(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthBiasClamp(boolean value) {
            VkPhysicalDeviceFeatures.ndepthBiasClamp(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer fillModeNonSolid(boolean value) {
            VkPhysicalDeviceFeatures.nfillModeNonSolid(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthBounds(boolean value) {
            VkPhysicalDeviceFeatures.ndepthBounds(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer wideLines(boolean value) {
            VkPhysicalDeviceFeatures.nwideLines(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer largePoints(boolean value) {
            VkPhysicalDeviceFeatures.nlargePoints(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer alphaToOne(boolean value) {
            VkPhysicalDeviceFeatures.nalphaToOne(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer multiViewport(boolean value) {
            VkPhysicalDeviceFeatures.nmultiViewport(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer samplerAnisotropy(boolean value) {
            VkPhysicalDeviceFeatures.nsamplerAnisotropy(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer textureCompressionETC2(boolean value) {
            VkPhysicalDeviceFeatures.ntextureCompressionETC2(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer textureCompressionASTC_LDR(boolean value) {
            VkPhysicalDeviceFeatures.ntextureCompressionASTC_LDR(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer textureCompressionBC(boolean value) {
            VkPhysicalDeviceFeatures.ntextureCompressionBC(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer occlusionQueryPrecise(boolean value) {
            VkPhysicalDeviceFeatures.nocclusionQueryPrecise(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer pipelineStatisticsQuery(boolean value) {
            VkPhysicalDeviceFeatures.npipelineStatisticsQuery(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer vertexPipelineStoresAndAtomics(boolean value) {
            VkPhysicalDeviceFeatures.nvertexPipelineStoresAndAtomics(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer fragmentStoresAndAtomics(boolean value) {
            VkPhysicalDeviceFeatures.nfragmentStoresAndAtomics(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderTessellationAndGeometryPointSize(boolean value) {
            VkPhysicalDeviceFeatures.nshaderTessellationAndGeometryPointSize(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderImageGatherExtended(boolean value) {
            VkPhysicalDeviceFeatures.nshaderImageGatherExtended(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageImageExtendedFormats(boolean value) {
            VkPhysicalDeviceFeatures.nshaderStorageImageExtendedFormats(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageImageMultisample(boolean value) {
            VkPhysicalDeviceFeatures.nshaderStorageImageMultisample(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageImageReadWithoutFormat(boolean value) {
            VkPhysicalDeviceFeatures.nshaderStorageImageReadWithoutFormat(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageImageWriteWithoutFormat(boolean value) {
            VkPhysicalDeviceFeatures.nshaderStorageImageWriteWithoutFormat(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderUniformBufferArrayDynamicIndexing(boolean value) {
            VkPhysicalDeviceFeatures.nshaderUniformBufferArrayDynamicIndexing(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderSampledImageArrayDynamicIndexing(boolean value) {
            VkPhysicalDeviceFeatures.nshaderSampledImageArrayDynamicIndexing(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageBufferArrayDynamicIndexing(boolean value) {
            VkPhysicalDeviceFeatures.nshaderStorageBufferArrayDynamicIndexing(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageImageArrayDynamicIndexing(boolean value) {
            VkPhysicalDeviceFeatures.nshaderStorageImageArrayDynamicIndexing(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderClipDistance(boolean value) {
            VkPhysicalDeviceFeatures.nshaderClipDistance(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderCullDistance(boolean value) {
            VkPhysicalDeviceFeatures.nshaderCullDistance(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderFloat64(boolean value) {
            VkPhysicalDeviceFeatures.nshaderFloat64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderInt64(boolean value) {
            VkPhysicalDeviceFeatures.nshaderInt64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderInt16(boolean value) {
            VkPhysicalDeviceFeatures.nshaderInt16(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderResourceResidency(boolean value) {
            VkPhysicalDeviceFeatures.nshaderResourceResidency(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderResourceMinLod(boolean value) {
            VkPhysicalDeviceFeatures.nshaderResourceMinLod(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseBinding(boolean value) {
            VkPhysicalDeviceFeatures.nsparseBinding(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidencyBuffer(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidencyBuffer(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidencyImage2D(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidencyImage2D(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidencyImage3D(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidencyImage3D(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidency2Samples(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidency2Samples(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidency4Samples(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidency4Samples(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidency8Samples(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidency8Samples(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidency16Samples(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidency16Samples(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sparseResidencyAliased(boolean value) {
            VkPhysicalDeviceFeatures.nsparseResidencyAliased(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer variableMultisampleRate(boolean value) {
            VkPhysicalDeviceFeatures.nvariableMultisampleRate(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer inheritedQueries(boolean value) {
            VkPhysicalDeviceFeatures.ninheritedQueries(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

