/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceGroupPropertiesKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PHYSICALDEVICES;
    public static final int SUBSETALLOCATION;

    VkPhysicalDeviceGroupPropertiesKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceGroupPropertiesKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceGroupPropertiesKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPhysicalDeviceGroupPropertiesKHX.nsType(this.address());
    }

    public long pNext() {
        return VkPhysicalDeviceGroupPropertiesKHX.npNext(this.address());
    }

    public int physicalDeviceCount() {
        return VkPhysicalDeviceGroupPropertiesKHX.nphysicalDeviceCount(this.address());
    }

    public PointerBuffer physicalDevices() {
        return VkPhysicalDeviceGroupPropertiesKHX.nphysicalDevices(this.address());
    }

    public long physicalDevices(int index) {
        return VkPhysicalDeviceGroupPropertiesKHX.nphysicalDevices(this.address(), index);
    }

    public boolean subsetAllocation() {
        return VkPhysicalDeviceGroupPropertiesKHX.nsubsetAllocation(this.address()) != 0;
    }

    public static VkPhysicalDeviceGroupPropertiesKHX malloc() {
        return VkPhysicalDeviceGroupPropertiesKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPhysicalDeviceGroupPropertiesKHX calloc() {
        return VkPhysicalDeviceGroupPropertiesKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPhysicalDeviceGroupPropertiesKHX create() {
        return new VkPhysicalDeviceGroupPropertiesKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceGroupPropertiesKHX create(long address) {
        return address == 0L ? null : new VkPhysicalDeviceGroupPropertiesKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceGroupPropertiesKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceGroupPropertiesKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPhysicalDeviceGroupPropertiesKHX mallocStack() {
        return VkPhysicalDeviceGroupPropertiesKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceGroupPropertiesKHX callocStack() {
        return VkPhysicalDeviceGroupPropertiesKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceGroupPropertiesKHX mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceGroupPropertiesKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceGroupPropertiesKHX callocStack(MemoryStack stack) {
        return VkPhysicalDeviceGroupPropertiesKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceGroupPropertiesKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceGroupPropertiesKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceGroupPropertiesKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceGroupPropertiesKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nphysicalDeviceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PHYSICALDEVICECOUNT);
    }

    public static PointerBuffer nphysicalDevices(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PHYSICALDEVICES, 32);
    }

    public static long nphysicalDevices(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 32);
        }
        return MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICES + (long)(index * POINTER_SIZE));
    }

    public static int nsubsetAllocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBSETALLOCATION);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceGroupPropertiesKHX.__struct(VkPhysicalDeviceGroupPropertiesKHX.__member(4), VkPhysicalDeviceGroupPropertiesKHX.__member(POINTER_SIZE), VkPhysicalDeviceGroupPropertiesKHX.__member(4), VkPhysicalDeviceGroupPropertiesKHX.__array(POINTER_SIZE, 32), VkPhysicalDeviceGroupPropertiesKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PHYSICALDEVICES = layout.offsetof(3);
        SUBSETALLOCATION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceGroupPropertiesKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceGroupPropertiesKHX newInstance(long address) {
            return new VkPhysicalDeviceGroupPropertiesKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPhysicalDeviceGroupPropertiesKHX.nsType(this.address());
        }

        public long pNext() {
            return VkPhysicalDeviceGroupPropertiesKHX.npNext(this.address());
        }

        public int physicalDeviceCount() {
            return VkPhysicalDeviceGroupPropertiesKHX.nphysicalDeviceCount(this.address());
        }

        public PointerBuffer physicalDevices() {
            return VkPhysicalDeviceGroupPropertiesKHX.nphysicalDevices(this.address());
        }

        public long physicalDevices(int index) {
            return VkPhysicalDeviceGroupPropertiesKHX.nphysicalDevices(this.address(), index);
        }

        public boolean subsetAllocation() {
            return VkPhysicalDeviceGroupPropertiesKHX.nsubsetAllocation(this.address()) != 0;
        }
    }
}

